/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.world;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.camera.Camera;
import com.estrelsteel.engine1.collide.CollideMap;
import com.estrelsteel.engine1.entitiy.Entity;
import com.estrelsteel.engine1.entitiy.block.Block;
import com.estrelsteel.engine1.tile.Tile;
import com.estrelsteel.engine1.tile.TileType;
import com.estrelsteel.engine1.world.Chunk;
import com.estrelsteel.engine1.world.Location;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class World {
    private ArrayList<Chunk> chunks = new ArrayList();
    private ArrayList<Tile> tiles = new ArrayList();
    private ArrayList<Tile> collideTiles = new ArrayList();
    private ArrayList<Entity> entities = new ArrayList();
    private ArrayList<Camera> cameras = new ArrayList();
    private ArrayList<CollideMap> maps = new ArrayList();
    private int mapPos = 0;
    private Camera mainCamera;
    private double width;
    private double height;

    public World() {
        this.width = 1.0;
        this.height = 1.0;
        this.cameras.add(new Camera(new Location(0, 0)));
        this.mainCamera = this.cameras.get(0);
    }

    public World(double width, double height) {
        this.width = width;
        this.height = height;
        this.cameras.add(new Camera(new Location(0, 0)));
        this.mainCamera = this.cameras.get(0);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public ArrayList<Chunk> getChunks() {
        return this.chunks;
    }

    public ArrayList<Tile> getAllTiles() {
        return this.tiles;
    }

    public ArrayList<Tile> getCollideTiles() {
        return this.collideTiles;
    }

    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    public ArrayList<Camera> getCameras() {
        return this.cameras;
    }

    public ArrayList<CollideMap> getCollideMaps() {
        return this.maps;
    }

    public int getCollideMapPosition() {
        return this.mapPos;
    }

    public Camera getMainCamera() {
        return this.mainCamera;
    }

    public void addChunk(Chunk chunk) {
        this.chunks.add(chunk);
    }

    public void addTile(Tile tile) {
        if (tile.getCollide()) {
            this.collideTiles.add(tile);
            this.tiles.add(tile);
        } else {
            this.tiles.add(tile);
        }
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    public void addCamera(Camera camera) {
        this.cameras.add(camera);
    }

    public void addCollideMap(CollideMap map) {
        this.maps.add(map);
    }

    public Graphics2D renderWorld(Graphics2D ctx) {
        Tile t;
        AffineTransform trans;
        this.mainCamera.focus(this);
        int x = this.mainCamera.getLocation().getX();
        int y = this.mainCamera.getLocation().getY();
        int displayX = 0;
        int displayY = 0;
        int displayXE = 0;
        int displayYE = 0;
        AffineTransform transE = new AffineTransform();
        displayX = this.mainCamera.getFollowX() ? this.maps.get(this.mapPos).getLocation().getX() - this.maps.get(this.mapPos).getLocation().getWidth() / 2 + x : this.maps.get(this.mapPos).getLocation().getX() + x;
        displayY = this.mainCamera.getFollowY() ? this.maps.get(this.mapPos).getLocation().getY() - this.maps.get(this.mapPos).getLocation().getHeight() / 2 + y : this.maps.get(this.mapPos).getLocation().getY() + y;
        if (displayX + this.maps.get(this.mapPos).getLocation().getWidth() > -10 && displayX < Engine1.startWidth + 10 && displayY + this.maps.get(this.mapPos).getLocation().getHeight() > -10 && displayY < Engine1.startHeight + 10) {
            if (!this.maps.get(this.mapPos).getCurrentImage().isImageLoaded()) {
                this.maps.get(this.mapPos).getCurrentImage().loadImage();
            }
            trans = new AffineTransform();
            trans.rotate(Math.toRadians(this.maps.get(this.mapPos).getLocation().getRotation()), this.maps.get(this.mapPos).getCentre().getX() + x, this.maps.get(this.mapPos).getCentre().getY() + y);
            trans.translate(displayX, displayY);
            trans.scale(this.maps.get(this.mapPos).getLocation().getWidth() / this.maps.get(this.mapPos).getType().getLocation().getWidth(), this.maps.get(this.mapPos).getLocation().getHeight() / this.maps.get(this.mapPos).getType().getLocation().getHeight());
            ctx.drawImage(this.maps.get(this.mapPos).getCurrentImage().getEntity(), trans, null);
        }
        int i = 0;
        while (i < this.chunks.size()) {
            Chunk c = this.chunks.get(i);
            displayX = this.mainCamera.getFollowX() ? c.getBounds().getX() - c.getBounds().getWidth() / 2 + x : c.getBounds().getX() + x;
            displayY = this.mainCamera.getFollowY() ? c.getBounds().getY() - c.getBounds().getHeight() / 2 + y : c.getBounds().getY() + y;
            if (displayX + c.getBounds().getWidth() > -300 && displayX < Engine1.startWidth + 10 && displayY + c.getBounds().getHeight() > -10 && displayY < Engine1.startHeight + 10) {
                int j = 0;
                while (j < c.getTiles().size()) {
                    t = c.getTiles().get(j);
                    if (t.getType() != TileType.UNKOWN) {
                        displayX = this.mainCamera.getFollowX() ? t.getLocation().getX() - t.getLocation().getWidth() / 2 + x : t.getLocation().getX() + x;
                        displayY = this.mainCamera.getFollowY() ? t.getLocation().getY() - t.getLocation().getHeight() / 2 + y : t.getLocation().getY() + y;
                        if (displayX + t.getLocation().getWidth() > -10 && displayX < Engine1.startWidth + 10 && displayY + t.getLocation().getHeight() > -10 && displayY < Engine1.startHeight + 10) {
                            if (!t.getType().getImage().isImageLoaded()) {
                                t.getType().getImage().loadImage();
                            }
                            trans = new AffineTransform();
                            trans.translate(displayX, displayY);
                            trans.scale(t.getLocation().getWidth() / t.getType().getLocation().getWidth(), t.getLocation().getHeight() / t.getType().getLocation().getHeight());
                            trans.rotate(Math.toRadians(t.getLocation().getRotation()), t.getLocation().getWidth() / 2, t.getLocation().getHeight() / 2);
                            ctx.drawImage(t.getType().getImage().getTile(), trans, null);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.tiles.size()) {
            t = this.tiles.get(i);
            if (t.getType() != TileType.UNKOWN) {
                displayX = this.mainCamera.getFollowX() ? t.getLocation().getX() - t.getLocation().getWidth() / 2 + x : t.getLocation().getX() + x;
                displayY = this.mainCamera.getFollowY() ? t.getLocation().getY() - t.getLocation().getHeight() / 2 + y : t.getLocation().getY() + y;
                if (displayX + t.getLocation().getWidth() > -10 && displayX < Engine1.startWidth + 10 && displayY + t.getLocation().getHeight() > -10 && displayY < Engine1.startHeight + 10) {
                    if (!t.getType().getImage().isImageLoaded()) {
                        t.getType().getImage().loadImage();
                    }
                    trans = new AffineTransform();
                    trans.translate(displayX, displayY);
                    trans.scale(t.getLocation().getWidth() / t.getType().getLocation().getWidth(), t.getLocation().getHeight() / t.getType().getLocation().getHeight());
                    trans.rotate(Math.toRadians(t.getLocation().getRotation()), t.getLocation().getWidth() / (t.getType().getImage().getLocation().getWidth() / 2), t.getLocation().getHeight() / (t.getType().getImage().getLocation().getHeight() / 2));
                    ctx.drawImage(t.getType().getImage().getTile(), trans, null);
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.entities.size()) {
            Entity e = this.entities.get(i);
            if (this.mainCamera.getFollowX()) {
                if (this.mainCamera.getEntity().equals(e)) {
                    displayX = Engine1.WIDTH / 2 - e.getLocation().getWidth() / 2;
                    if (e.getEquiped() != null) {
                        displayXE = e.getEquiped().getLocation().getX() - e.getEquiped().getLocation().getWidth() / 2 + x;
                    }
                } else {
                    displayX = e.getLocation().getX() - e.getLocation().getWidth() / 2 + x;
                    if (e.getEquiped() != null) {
                        displayXE = e.getEquiped().getLocation().getX() - e.getEquiped().getLocation().getWidth() / 2 + x;
                    }
                }
            } else {
                displayX = e.getLocation().getX() + x;
                if (e.getEquiped() != null) {
                    displayXE = e.getEquiped().getLocation().getX() + x;
                }
            }
            if (this.mainCamera.getFollowY()) {
                if (this.mainCamera.getEntity().equals(e)) {
                    displayY = Engine1.HEIGHT / 2 - e.getLocation().getHeight() / 2;
                    if (e.getEquiped() != null) {
                        displayYE = e.getEquiped().getLocation().getY() - e.getEquiped().getLocation().getHeight() / 2 + y;
                    }
                } else {
                    displayY = e.getLocation().getY() - e.getLocation().getHeight() / 2 + y;
                    if (e.getEquiped() != null) {
                        displayYE = e.getEquiped().getLocation().getY() - e.getEquiped().getLocation().getHeight() / 2 + y;
                    }
                }
            } else {
                displayY = e.getLocation().getY() + y;
                if (e.getEquiped() != null) {
                    displayYE = e.getEquiped().getLocation().getY() + y;
                }
            }
            if (displayX + e.getLocation().getWidth() > 0 && displayX < Engine1.startWidth && displayY + e.getLocation().getHeight() > 0 && displayY < Engine1.startHeight) {
                if (!e.getCurrentImage().isImageLoaded()) {
                    e.getCurrentImage().loadImage();
                }
                trans = new AffineTransform();
                if (e instanceof Block || e instanceof CollideMap) {
                    trans.rotate(Math.toRadians(e.getLocation().getRotation()), this.maps.get(this.mapPos).getCentre().getX() + x, this.maps.get(this.mapPos).getCentre().getY() + y);
                } else {
                    trans.rotate(Math.toRadians(e.getLocation().getRotation()), e.getLocation().getWidth() / (e.getCurrentImage().getLocation().getWidth() / 2), e.getLocation().getHeight() / (e.getCurrentImage().getLocation().getHeight() / 2));
                }
                trans.translate(displayX, displayY);
                trans.scale(e.getLocation().getWidth() / e.getCurrentImage().getLocation().getWidth(), e.getLocation().getHeight() / e.getCurrentImage().getLocation().getHeight());
                if (e.getEquiped() != null) {
                    transE = new AffineTransform();
                    transE.translate(displayXE, displayYE);
                    transE.scale(e.getEquiped().getLocation().getWidth() / e.getEquiped().getCurrentImage().getLocation().getWidth(), e.getEquiped().getLocation().getHeight() / e.getEquiped().getCurrentImage().getLocation().getHeight());
                    transE.rotate(Math.toRadians(e.getEquiped().getLocation().getRotation()), e.getEquiped().getLocation().getWidth() / (e.getEquiped().getCurrentImage().getLocation().getWidth() / 2), e.getEquiped().getLocation().getHeight() / (e.getEquiped().getCurrentImage().getLocation().getHeight() / 2));
                }
                if (e.getEquiped() != null && e.getTopEquip()) {
                    ctx.drawImage(e.getEquiped().getCurrentImage().getEntity(), transE, null);
                }
                ctx.drawImage(e.getCurrentImage().getEntity(), trans, null);
                if (e.getEquiped() != null && !e.getTopEquip()) {
                    ctx.drawImage(e.getEquiped().getCurrentImage().getEntity(), transE, null);
                }
            }
            ++i;
        }
        return ctx;
    }

    public void sortToChunks() {
        boolean found = false;
        int i = 0;
        while (i < this.tiles.size()) {
            Chunk chunk;
            Tile t = this.tiles.get(i);
            found = false;
            for (Chunk c : this.chunks) {
                if (!c.addTile(this.tiles.get(i))) continue;
                found = true;
                this.tiles.remove(i);
                if (--i >= 0) continue;
                i = 0;
            }
            if (!found && (chunk = new Chunk(new Location(t.getLocation().getX() / 512 * 128, t.getLocation().getY() / 512 * 128, 512, 512))).addTile(this.tiles.get(i))) {
                this.chunks.add(chunk);
                this.tiles.remove(i);
                if (--i < 0) {
                    i = 0;
                }
            }
            ++i;
        }
    }

    public boolean equals(World world) {
        return world.getWidth() == this.width && world.getHeight() == this.height && world.getAllTiles() == this.tiles && world.getEntities() == this.entities && this.cameras == world.getCameras();
    }

    public boolean doesCollide(Entity e, Location loc) {
        for (Tile tile : this.collideTiles) {
            if (!tile.getCollide() || !tile.getLocation().collidesWith(loc)) continue;
            return true;
        }
        for (Entity entity : this.entities) {
            if (e.equals(entity) || !entity.getCollide() || !loc.collidesWith(entity.getLocation())) continue;
            return true;
        }
        return false;
    }

    public boolean doesCollide(Tile t, Location loc) {
        for (Tile tile : this.collideTiles) {
            if (t.equals(tile) || !tile.getCollide() || !tile.getLocation().collidesWith(loc)) continue;
            return true;
        }
        for (Entity entity : this.entities) {
            if (!entity.getCollide() || !loc.collidesWith(entity.getLocation())) continue;
            return true;
        }
        return false;
    }

    public boolean containsTile(Tile tile) {
        for (Tile t : this.tiles) {
            if (!tile.equals(t)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntity(Entity entity) {
        for (Entity e : this.entities) {
            if (!entity.basicEquals(e)) continue;
            return true;
        }
        return false;
    }

    public boolean containsCamera(Camera camera) {
        for (Camera c : this.cameras) {
            if (!camera.equals(c)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> convertToJava(ArrayList<String> lines) {
        for (Tile t : this.tiles) {
            lines.add("world.addTile(" + t.convertToJava() + ");");
        }
        return lines;
    }

    public ArrayList<String> convertToES1File(ArrayList<String> lines) {
        for (Tile t : this.tiles) {
            lines = t.convertToES1File(lines);
            lines.add("");
        }
        lines.add("@ END OF TILES");
        for (Entity e : this.entities) {
            lines = e.convertToES1File(lines);
            lines.add("");
        }
        lines.add("@ END OF ENTITIES");
        int mainCamera = -1;
        int i = 1;
        while (i < this.cameras.size()) {
            Camera c = this.cameras.get(i);
            lines = c.convertToES1File(lines);
            lines.add("");
            if (c.equals(mainCamera)) {
                mainCamera = i;
            }
            ++i;
        }
        lines.add("@ END OF CAMERAS");
        lines.add("set mainCamera " + mainCamera);
        return lines;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setChunks(ArrayList<Chunk> chunks) {
        this.chunks = chunks;
    }

    public void setTiles(ArrayList<Tile> tiles) {
        this.tiles = tiles;
    }

    public void setCollideTiles(ArrayList<Tile> collideTiles) {
        this.collideTiles = collideTiles;
    }

    public void setEntities(ArrayList<Entity> entities) {
        this.entities = entities;
    }

    public void setCameras(ArrayList<Camera> cameras) {
        this.cameras = cameras;
    }

    public void setCollideMaps(ArrayList<CollideMap> maps) {
        this.maps = maps;
    }

    public void setCollideMapPosition(int mapPos) {
        this.mapPos = mapPos;
    }

    public void setMainCamera(Camera mainCamera) {
        this.mainCamera = mainCamera;
    }

    public void setMainCamera(int camera) {
        this.mainCamera = this.cameras.get(camera);
    }
}

