/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.world;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Location {
    private int x;
    private int y;
    private int w;
    private int h;
    private double rotation;
    private int startX;
    private int startY;
    private int startW;
    private int startH;

    public Location() {
        this.x = 0;
        this.y = 0;
        this.w = 0;
        this.h = 0;
        this.rotation = 0.0;
        this.startX = this.x;
        this.startY = this.y;
        this.startW = this.w;
        this.startH = this.h;
    }

    public Location(int x, int y) {
        this.x = x;
        this.y = y;
        this.w = 0;
        this.h = 0;
        this.rotation = 0.0;
        this.startX = this.x;
        this.startY = this.y;
        this.startW = this.w;
        this.startH = this.h;
    }

    public Location(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.rotation = 0.0;
        this.startX = this.x;
        this.startY = this.y;
        this.startW = this.w;
        this.startH = this.h;
    }

    public Location(int x, int y, int w, int h, double rotation) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.rotation = rotation;
        this.startX = this.x;
        this.startY = this.y;
        this.startW = this.w;
        this.startH = this.h;
    }

    public int getX() {
        return this.x;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getY() {
        return this.y;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getWidth() {
        return this.w;
    }

    public int getStartWidth() {
        return this.startW;
    }

    public int getHeight() {
        return this.h;
    }

    public double getRotation() {
        return this.rotation;
    }

    public int getStartHeight() {
        return this.startH;
    }

    public int getRawXDistance(Location loc) {
        return loc.getX() - this.x;
    }

    public int getRawXDistance(int x) {
        return x - this.x;
    }

    public int getRawYDistance(Location loc) {
        return loc.getY() - this.y;
    }

    public int getRawYDistance(int y) {
        return y - this.y;
    }

    public int getXDistance(Location loc) {
        return Math.abs(loc.getX() - this.x);
    }

    public int getXDistance(int x) {
        return Math.abs(x - this.x);
    }

    public int getYDistance(Location loc) {
        return Math.abs(loc.getY() - this.y);
    }

    public int getYDistance(int y) {
        return Math.abs(y - this.y);
    }

    public double getDistance(Location loc) {
        return Math.sqrt(this.getYDistance(loc) * this.getYDistance(loc) + this.getXDistance(loc) * this.getXDistance(loc));
    }

    public Location getRotatedPoint(int x, int y, double rotation) {
        int x2 = (int)((double)x * Math.cos(Math.toRadians(rotation)) - (double)y * Math.sin(Math.toRadians(rotation)));
        int y2 = (int)((double)y * Math.cos(Math.toRadians(rotation)) + (double)x * Math.sin(Math.toRadians(rotation)));
        return new Location(x2, y2);
    }

    public boolean collidesWith(Location loc) {
        return this.x + this.w > loc.getX() && this.x < loc.getX() + loc.getWidth() && this.y + this.h > loc.getY() && this.y < loc.getY() + loc.getHeight();
    }

    public boolean collidesWith(int x, int y, int w, int h) {
        Location loc = new Location(x, y, w, h);
        return this.collidesWith(loc);
    }

    public boolean equals(Location loc) {
        return this.x == loc.getX() && this.y == loc.getY() && this.w == loc.getWidth() && this.h == loc.getHeight();
    }

    public String toString() {
        return "X: " + this.x + "\tY: " + this.y + "\tW: " + this.w + "\tH: " + this.h;
    }

    public String convertToJava() {
        return "new Location(" + this.x + ", " + this.y + ", " + this.w + ", " + this.h + ", " + this.rotation + ")";
    }

    public ArrayList<String> convertToES1File(ArrayList<String> lines) {
        lines.add("x = " + this.x);
        lines.add("y = " + this.y);
        lines.add("w = " + this.w);
        lines.add("h = " + this.h);
        return lines;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setStartX(int startX) {
        this.startX = startX;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    public void setWidth(int w) {
        this.w = w;
    }

    public void setStartWidth(int startW) {
        this.startW = startW;
    }

    public void setHeight(int h) {
        this.h = h;
    }

    public void setStartHeight(int startH) {
        this.startH = startH;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }
}

