/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.tile;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.tile.TileImage;
import com.estrelsteel.engine1.world.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TileType {
    UNKOWN(-1, "UNKOWN", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 0, 16, 16)),
    BACK(0, "BACK", String.valueOf(Engine1.filesPath) + "/assets/res/img/back.png", new Location(0, 0, 256, 256));

    private int id;
    private String name;
    private TileImage img;
    private Location loc;

    private TileType() {
        this.id = -1;
        this.name = "UNKOWN";
    }

    private TileType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    private TileType(int id, String name, String src, Location loc) {
        this.id = id;
        this.name = name;
        this.loc = loc;
        this.img = new TileImage(src, this.loc);
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TileImage getImage() {
        return this.img;
    }

    public Location getLocation() {
        return this.loc;
    }

    public static TileType findByName(String name) {
        TileType[] tileTypeArray = TileType.values();
        int n = tileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TileType type = tileTypeArray[n2];
            if (type.getName().equalsIgnoreCase(name)) {
                return type;
            }
            ++n2;
        }
        return UNKOWN;
    }

    public static TileType findByID(int id) {
        TileType[] tileTypeArray = TileType.values();
        int n = tileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TileType type = tileTypeArray[n2];
            if (type.getID() == id) {
                return type;
            }
            ++n2;
        }
        return UNKOWN;
    }

    public static void updateSRC(String filesPath) {
        int i = 0;
        while (i < TileType.values().length) {
            TileType.values()[i].setSRC(String.valueOf(filesPath) + TileType.values()[i].getImage().getSRC());
            ++i;
        }
    }

    private void setSRC(String src) {
        this.img = new TileImage(src, this.loc);
    }
}

