/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.tile;

import com.estrelsteel.engine1.world.Image;
import com.estrelsteel.engine1.world.Location;
import java.awt.image.BufferedImage;

public class TileImage
extends Image {
    private Location loc;
    private BufferedImage tImg;

    public TileImage(String src) {
        super(src);
        this.loc = new Location(0, 0, 16, 16);
    }

    public TileImage(String src, boolean scan) {
        super(src, scan);
        this.loc = new Location(0, 0, 16, 16);
    }

    public TileImage(String src, Location loc) {
        super(src);
        this.loc = loc;
    }

    public TileImage(String src, Location loc, boolean scan) {
        super(src, scan);
        this.loc = loc;
    }

    public Location getLocation() {
        return this.loc;
    }

    public BufferedImage getTile() {
        if (!this.isImageLoaded()) {
            this.loadImage();
        }
        if (this.tImg == null) {
            this.tImg = this.getImage().getSubimage(this.loc.getX(), this.loc.getY(), this.loc.getWidth(), this.loc.getHeight());
            if (this.getScan()) {
                boolean keepScan = false;
                int x = 0;
                while (x < this.tImg.getWidth()) {
                    int y = 0;
                    while (y < this.tImg.getHeight()) {
                        if (this.tImg.getRGB(x, y) == -1310580 || this.tImg.getRGB(x, y) == -16777216) {
                            this.tImg.setRGB(x, y, 0);
                            keepScan = true;
                        }
                        ++y;
                    }
                    ++x;
                }
                if (!keepScan) {
                    this.setScan(false);
                }
            }
        }
        return this.tImg;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }
}

