/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.tile;

import com.estrelsteel.engine1.handler.Handler;
import com.estrelsteel.engine1.tile.TileType;
import com.estrelsteel.engine1.world.Location;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tile {
    private Location loc;
    private TileType type;
    private Handler controls;
    private boolean collide;
    private AffineTransform trans;

    public Tile() {
        this.loc = new Location(0, 0, 16, 16);
        this.type = TileType.UNKOWN;
    }

    public Tile(TileType type, Location loc) {
        this.loc = loc;
        this.type = type;
        this.collide = true;
    }

    public Tile(TileType type, Location loc, Handler controls) {
        this.loc = loc;
        this.type = type;
        this.controls = controls;
        this.collide = true;
    }

    public Tile(TileType type, Location loc, boolean collide, Handler controls) {
        this.loc = loc;
        this.type = type;
        this.controls = controls;
        this.collide = collide;
    }

    public Location getLocation() {
        return this.loc;
    }

    public TileType getType() {
        return this.type;
    }

    public Handler getControls() {
        return this.controls;
    }

    public boolean getCollide() {
        return this.collide;
    }

    public AffineTransform getTransformation() {
        return this.trans;
    }

    public boolean equals(Tile tile) {
        return this.loc.equals(tile.getLocation()) && this.type.getID() == tile.getType().getID();
    }

    public String convertToJava() {
        return "new Tile(TileType." + this.type.getName() + ", " + this.loc.convertToJava() + ", " + this.collide + ", null)";
    }

    public ArrayList<String> convertToES1File(ArrayList<String> lines) {
        lines.add("new Tile :");
        lines = this.loc.convertToES1File(lines);
        lines.add("type = " + this.type.getName());
        lines.add("collide = " + this.collide);
        lines.add("end");
        return lines;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public void setType(TileType type) {
        this.type = type;
    }

    public void setControls(Handler controls) {
        this.controls = controls;
    }

    public void setCollide(boolean collide) {
        this.collide = collide;
    }

    public void setTransformation(AffineTransform trans) {
        this.trans = trans;
    }
}

