/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.sound;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sound {
    private String src;
    private Clip clip;

    public Sound(String src) {
        this.src = src;
    }

    public String getSRC() {
        return this.src;
    }

    public Clip getClip() {
        return this.clip;
    }

    public synchronized void play() {
        if (this.clip == null || !this.clip.isRunning()) {
            try {
                File file = new File(this.src);
                this.clip = AudioSystem.getClip();
                AudioInputStream ais = AudioSystem.getAudioInputStream(file);
                this.clip.open(ais);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
            }
            this.clip.flush();
            this.clip.start();
        }
    }

    public void setSRC(String src) {
        this.src = src;
    }

    public void setClip(Clip clip) {
        this.clip = clip;
    }
}

