/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.sound;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.sound.Sound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Effects {
    INVALID(-1, null),
    SELECT(0, new Sound(String.valueOf(Engine1.filesPath) + "/assets/res/sfx/button_click.wav")),
    PLACE(1, new Sound(String.valueOf(Engine1.filesPath) + "/assets/res/sfx/place.wav")),
    DEFEAT(2, new Sound(String.valueOf(Engine1.filesPath) + "/assets/res/sfx/defeat.wav")),
    PAINT(3, new Sound(String.valueOf(Engine1.filesPath) + "/assets/res/sfx/paint.wav")),
    VICTORY(4, new Sound(String.valueOf(Engine1.filesPath) + "/assets/res/sfx/victory.wav"));

    private int id;
    private Sound sound;

    private Effects(int id, Sound sound) {
        this.id = id;
        this.sound = sound;
    }

    public int getID() {
        return this.id;
    }

    public Sound getSound() {
        return this.sound;
    }

    public static Effects findByID(int id) {
        Effects[] effectsArray = Effects.values();
        int n = effectsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Effects sfx = effectsArray[n2];
            if (sfx.getID() == id) {
                return sfx;
            }
            ++n2;
        }
        return INVALID;
    }

    public static void updateSRC(String filesPath) {
        int i = 0;
        while (i < Effects.values().length) {
            Effects.values()[i].setSRC(String.valueOf(filesPath) + Effects.values()[i].getSound().getSRC());
            ++i;
        }
    }

    private void setSRC(String src) {
        this.sound = new Sound(src);
    }
}

