/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.menu.controller;

import com.estrelsteel.engine1.handler.Handler;
import com.estrelsteel.engine1.menu.Menu;
import com.estrelsteel.engine1.world.Image;
import com.estrelsteel.engine1.world.Location;
import java.awt.Graphics;

public abstract class MenuController
extends Handler {
    private Menu menu;
    private double tempX;
    private double tempY;
    private double alpha = 0.0;

    public MenuController(Menu menu, String name) {
        super(name);
        this.menu = menu;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public abstract void execute(int var1);

    public abstract void execute(int var1, double var2);

    public Menu glide(Location glideStart, Location loc, double time) {
        if (!new Location(this.menu.getLocation().getX() * -1, this.menu.getLocation().getY() * -1, 0, 0).equals(loc)) {
            double frameMoveX = (double)loc.getRawXDistance(glideStart) / time;
            double frameMoveY = (double)loc.getRawYDistance(glideStart) / time;
            this.tempX += frameMoveX;
            this.tempY += frameMoveY;
            this.menu.getLocation().setX((int)this.tempX);
            this.menu.getLocation().setY((int)this.tempY);
        }
        return this.menu;
    }

    public Graphics fadeOut(Graphics ctx, double time, Image img) {
        this.alpha += 255.0 / time;
        if (this.alpha > 255.0) {
            this.alpha = 255.0;
        }
        if (this.alpha < 0.0) {
            this.alpha = 0.0;
        }
        int x = 0;
        while (x < img.getImage().getWidth()) {
            int y = 0;
            while (y < img.getImage().getHeight()) {
                img.getImage().setRGB(x, y, (int)this.alpha);
                ++y;
            }
            ++x;
        }
        ctx.drawImage(img.getImage(), this.menu.getLocation().getX(), this.menu.getLocation().getY(), this.menu.getLocation().getWidth(), this.menu.getLocation().getHeight(), null);
        return ctx;
    }

    public Graphics fadeIn(Graphics ctx, double time, Image img) {
        this.alpha -= 255.0 / time;
        if (this.alpha > 255.0) {
            this.alpha = 255.0;
        }
        if (this.alpha < 0.0) {
            this.alpha = 0.0;
        }
        int x = 0;
        while (x < img.getImage().getWidth()) {
            int y = 0;
            while (y < img.getImage().getHeight()) {
                img.getImage().setRGB(x, y, (int)this.alpha);
                ++y;
            }
            ++x;
        }
        ctx.drawImage(img.getImage(), this.menu.getLocation().getX(), this.menu.getLocation().getY(), this.menu.getLocation().getWidth(), this.menu.getLocation().getHeight(), null);
        return ctx;
    }

    public boolean hasFaded() {
        return this.alpha >= 255.0 || this.alpha <= 0.0;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }
}

