/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.menu.controller;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.menu.Menu;
import com.estrelsteel.engine1.menu.MenuItem;
import com.estrelsteel.engine1.menu.MenuText;
import com.estrelsteel.engine1.menu.controller.MenuController;
import com.estrelsteel.engine1.sound.Effects;
import com.estrelsteel.engine1.world.Location;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;

public class MainMenuController
extends MenuController {
    private Engine1 engine;

    public MainMenuController(Menu menu, Engine1 engine) {
        super(menu, "MAIN_MENU_CONTROLLER");
        this.engine = engine;
    }

    public void mouseClicked(MouseEvent e) {
        if (!e.isConsumed() && this.getMenu().isOpen()) {
            Location point = new Location(e.getX(), e.getY());
            for (MenuItem item : this.getMenu().getMenuItems()) {
                if (!item.getClickLocation().collidesWith(point)) continue;
                if (item.getType() == MenuItem.MenuItemType.START) {
                    Effects.SELECT.getSound().play();
                    this.engine.contract.setOpen(true, this.engine);
                    this.engine.mainMenu.setOpen(false, this.engine);
                    e.consume();
                    continue;
                }
                if (item.getType() == MenuItem.MenuItemType.QUIT) {
                    Effects.SELECT.getSound().play();
                    try {
                        this.engine.stop();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    e.consume();
                    continue;
                }
                if (!(item instanceof MenuText) || !((MenuText)item).getText().equalsIgnoreCase("Restart Progress")) continue;
                this.engine.contractPos = 0;
                this.engine.updateContractMenu();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void execute(int id) {
    }

    public void execute(int id, double time) {
    }
}

