/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.menu;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.menu.MenuImage;
import com.estrelsteel.engine1.world.Location;
import java.util.ArrayList;

public class MenuItem {
    private MenuItemType type;
    private Location textLoc;
    private Location clickLoc;
    private boolean textOpen;
    private int lineSpace;

    public MenuItem(MenuItemType type, Location clickLoc) {
        this.type = type;
        this.textLoc = new Location(0, 0, 0, 0);
        this.clickLoc = clickLoc;
        this.textOpen = false;
        this.lineSpace = 15;
    }

    public MenuItem(MenuItemType type, Location textLoc, Location clickLoc) {
        this.type = type;
        this.textLoc = textLoc;
        this.clickLoc = clickLoc;
        this.textOpen = false;
        this.lineSpace = 15;
    }

    public MenuItemType getType() {
        return this.type;
    }

    public Location getTextLocation() {
        return this.textLoc;
    }

    public Location getClickLocation() {
        return this.clickLoc;
    }

    public int getLineSpace() {
        return this.lineSpace;
    }

    public boolean isTextOpen() {
        return this.textOpen;
    }

    public void setType(MenuItemType type) {
        this.type = type;
    }

    public void setTextLocation(Location textLoc) {
        this.textLoc = textLoc;
    }

    public void setClickLocation(Location clickLoc) {
        this.clickLoc = clickLoc;
    }

    public void setTextOpen(boolean textOpen) {
        this.textOpen = textOpen;
    }

    public void setLineSpace(int lineSpace) {
        this.lineSpace = lineSpace;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MenuItemType {
        UNKNOWN(-1, "UNKNOWN", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/hud.png"),
        TEXT(0, "TEXT", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 0, 16, 16)),
        CLOCK(1, "CLOCK", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(64, 16, 16, 16)),
        START(2, "START", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 0, 16, 16)),
        QUIT(3, "QUIT", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 0, 16, 16)),
        SPEAKER(4, "SPEAKER", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(80, 16, 16, 16)),
        SOUND(5, "SOUND", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(96, 16, 16, 16)),
        CREDIT(6, "CREDIT", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(112, 16, 16, 16)),
        PAINT(7, "PAINT", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 96, 16, 16)),
        PAPER(8, "PAPER", "null", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(32, 64, 32, 32));

        private int id;
        private String name;
        private ArrayList<String> description;
        private String rawDescription;
        private MenuImage image;

        private MenuItemType(int id, String name, String description, String src) {
            this.id = id;
            this.name = name;
            this.image = new MenuImage(src);
            String[] des = description.split("\u2702");
            this.description = new ArrayList();
            String[] stringArray = des;
            int n2 = des.length;
            int n3 = 0;
            while (n3 < n2) {
                String s = stringArray[n3];
                this.description.add(s);
                ++n3;
            }
            this.rawDescription = description;
        }

        private MenuItemType(int id, String name, String description, String src, Location loc) {
            this.id = id;
            this.name = name;
            this.image = new MenuImage(src, loc);
            String[] des = description.split("\u2702");
            this.description = new ArrayList();
            String[] stringArray = des;
            int n2 = des.length;
            int n3 = 0;
            while (n3 < n2) {
                String s = stringArray[n3];
                this.description.add(s);
                ++n3;
            }
            this.rawDescription = description;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<String> getDescription() {
            return this.description;
        }

        public MenuImage getMenuImage() {
            return this.image;
        }

        public String getRawDescription() {
            return this.rawDescription;
        }

        public static void updateSRC(String filesPath) {
            int i = 0;
            while (i < MenuItemType.values().length) {
                MenuItemType.values()[i].setSRC(String.valueOf(filesPath) + MenuItemType.values()[i].getMenuImage().getSRC());
                ++i;
            }
        }

        private void setSRC(String src) {
            this.image = new MenuImage(src, this.image.getLocation());
        }
    }
}

