/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.menu;

import com.estrelsteel.engine1.world.Image;
import com.estrelsteel.engine1.world.Location;
import java.awt.image.BufferedImage;

public class MenuImage
extends Image {
    private Location loc;
    private BufferedImage mImg;

    public MenuImage(String src) {
        super(src);
        this.loc = new Location(0, 0, 16, 16);
    }

    public MenuImage(String src, boolean scan) {
        super(src, scan);
        this.loc = new Location(0, 0, 16, 16);
    }

    public MenuImage(String src, Location loc) {
        super(src);
        this.loc = loc;
    }

    public MenuImage(String src, Location loc, boolean scan) {
        super(src, scan);
        this.loc = loc;
    }

    public Location getLocation() {
        return this.loc;
    }

    public BufferedImage getMenuImage() {
        if (!this.isImageLoaded()) {
            this.loadImage();
        }
        if (this.mImg == null) {
            this.mImg = this.getImage().getSubimage(this.loc.getX(), this.loc.getY(), this.loc.getWidth(), this.loc.getHeight());
            if (this.getScan()) {
                boolean keepScan = false;
                int x = 0;
                while (x < this.mImg.getWidth()) {
                    int y = 0;
                    while (y < this.mImg.getHeight()) {
                        if (this.mImg.getRGB(x, y) == -1310580 || this.mImg.getRGB(x, y) == -16777216) {
                            this.mImg.setRGB(x, y, 0);
                            keepScan = true;
                        }
                        ++y;
                    }
                    ++x;
                }
                if (!keepScan) {
                    this.setScan(false);
                }
            }
        }
        return this.mImg;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }
}

