/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.menu;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.menu.MenuImage;
import com.estrelsteel.engine1.menu.MenuItem;
import com.estrelsteel.engine1.menu.controller.MenuController;
import com.estrelsteel.engine1.world.Location;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menu {
    private String name;
    private ArrayList<MenuItem> items;
    private boolean open;
    private Location loc;
    private MenuController controller;
    private MenuImage image;

    public Menu(String name, Location loc, MenuImage image) {
        this.name = name;
        this.items = new ArrayList();
        this.open = false;
        this.loc = loc;
        this.image = image;
    }

    public Menu(String name, Location loc, ArrayList<MenuItem> items, MenuImage image, MenuController controller) {
        this.name = name;
        this.items = items;
        this.open = false;
        this.loc = loc;
        this.controller = controller;
        this.image = image;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<MenuItem> getMenuItems() {
        return this.items;
    }

    public Location getLocation() {
        return this.loc;
    }

    public MenuController getController() {
        return this.controller;
    }

    public MenuImage getMenuImage() {
        return this.image;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void addMenuItem(MenuItem item) {
        this.items.add(item);
    }

    public boolean equals(Menu menu) {
        return this.name.equalsIgnoreCase(menu.getName()) && this.items.containsAll(menu.getMenuItems());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMenuItems(ArrayList<MenuItem> items) {
        this.items = items;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public void setOpen(boolean open, Engine1 engine) {
        this.loc = new Location(0, 0, engine.getWidth(), engine.getHeight());
        this.setOpen(open);
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void setController(MenuController controller) {
        this.controller = controller;
    }

    public void setMenuImage(MenuImage image) {
        this.image = image;
    }
}

