/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.maps;

import com.estrelsteel.engine1.maps.Basics;
import com.estrelsteel.engine1.maps.Circles;
import com.estrelsteel.engine1.maps.Dev;
import com.estrelsteel.engine1.maps.Food;
import com.estrelsteel.engine1.maps.Points;
import com.estrelsteel.engine1.maps.Stars;
import com.estrelsteel.engine1.maps.TheEnd;
import com.estrelsteel.engine1.maps.Tools;
import com.estrelsteel.engine1.maps.Toys;
import com.estrelsteel.engine1.world.World;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public abstract class Map {
    public abstract World load1(World var1);

    public World load() {
        World world = new World(650.0, 650.0);
        this.load1(world);
        return world;
    }

    public static void generateFile(String name, World world) throws IOException {
        FileWriter fw = new FileWriter("src/com/estrelsteel/engine1/maps/" + name + ".java");
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("package com.estrelsteel.engine1.maps;\n\n");
        bw.write("import com.estrelsteel.engine1.tile.Tile;\n");
        bw.write("import com.estrelsteel.engine1.tile.TileType;\n");
        bw.write("import com.estrelsteel.engine1.world.Location;\n");
        bw.write("import com.estrelsteel.engine1.world.World;\n\n");
        bw.write("public class " + name + " extends Map {\n");
        bw.write("\tpublic World load1(World world) {\n");
        ArrayList<String> worldJava = world.convertToJava(new ArrayList<String>());
        int byteCount = 0;
        int method = 1;
        for (String line : worldJava) {
            bw.write("\t\t" + line + "\n");
            if ((byteCount += line.getBytes().length) < 64000) continue;
            byteCount = 0;
            bw.write("\t\tworld = load" + ++method + "(world);\n");
            bw.write("\t\treturn world;\n\t}\n");
            bw.write("\tpublic World load" + method + "(World world) {\n");
        }
        bw.write("\t\treturn world;\n\t}\n");
        bw.write("}");
        bw.flush();
        bw.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Maps {
        INVALID(-1, null),
        DEV(0, new Dev()),
        BASICS(1, new Basics()),
        TOYS(2, new Toys()),
        FOOD(3, new Food()),
        CIRCLES(4, new Circles()),
        TOOLS(5, new Tools()),
        STARS(6, new Stars()),
        POINTS(7, new Points()),
        THE_END(8, new TheEnd());

        private int id;
        private Map map;
        public static final int playableMaps = 0;

        private Maps(int id, Map map) {
            this.id = id;
            this.map = map;
        }

        public int getID() {
            return this.id;
        }

        public Map getMap() {
            return this.map;
        }

        public static Maps findByID(int id) {
            Maps[] mapsArray = Maps.values();
            int n = mapsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Maps map = mapsArray[n2];
                if (map.getID() == id) {
                    return map;
                }
                ++n2;
            }
            return INVALID;
        }

        public static Maps getRandomMap() {
            return Maps.findByID((int)(Math.random() * 0.0));
        }
    }
}

