/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.handler;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.entitiy.Entity;
import com.estrelsteel.engine1.menu.Menu;
import com.estrelsteel.engine1.tile.Tile;
import com.estrelsteel.engine1.world.World;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Handler
implements KeyListener,
MouseListener {
    private String name;

    public Handler(String name) {
        this.name = name;
    }

    public static void loadHandlers(Engine1 engine, ArrayList<World> worlds) {
        for (World world : worlds) {
            for (Tile t : world.getAllTiles()) {
                if (t.getControls() == null) continue;
                engine.addKeyListener(t.getControls());
                engine.addMouseListener(t.getControls());
            }
            for (Entity e : world.getEntities()) {
                if (e.getControls() == null) continue;
                engine.addKeyListener(e.getControls());
                engine.addMouseListener(e.getControls());
            }
        }
        for (Menu menu : engine.menus) {
            engine.addKeyListener(menu.getController());
            engine.addMouseListener(menu.getController());
        }
        engine.addKeyListener(engine.gameHandler);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public abstract void mouseClicked(MouseEvent var1);

    @Override
    public abstract void mouseEntered(MouseEvent var1);

    @Override
    public abstract void mouseExited(MouseEvent var1);

    @Override
    public abstract void mousePressed(MouseEvent var1);

    @Override
    public abstract void mouseReleased(MouseEvent var1);

    @Override
    public abstract void keyPressed(KeyEvent var1);

    @Override
    public abstract void keyReleased(KeyEvent var1);

    @Override
    public abstract void keyTyped(KeyEvent var1);
}

