/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.font;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.world.Image;
import com.estrelsteel.engine1.world.Location;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class Font {
    private String charBlock0 = "ABCDEFGH";
    private String charBlock1 = "IJKLMNOP";
    private String charBlock2 = "QRSTUVWX";
    private String charBlock3 = "YZ123456";
    private String charBlock4 = "7890.,!?";
    private String charBlock5 = ";:-_ ###";
    private Image image = new Image(String.valueOf(Engine1.filesPath) + "/assets/res/img/font.png");
    private Location charSize = new Location(0, 0, 16, 16);
    private Location textLoc = new Location(0, 0, 256, 32);
    private Location charSpace = new Location(0, 0, 2, 2);
    private ArrayList<BufferedImage> imgs = new ArrayList();

    public String getCharBlock0() {
        return this.charBlock0;
    }

    public String getCharBlock1() {
        return this.charBlock1;
    }

    public String getCharBlock2() {
        return this.charBlock2;
    }

    public String getCharBlock3() {
        return this.charBlock3;
    }

    public String getCharBlock4() {
        return this.charBlock4;
    }

    public String getCharBlock5() {
        return this.charBlock5;
    }

    public Location getCharSize() {
        return this.charSize;
    }

    public Location getTextLocation() {
        return this.textLoc;
    }

    public Location getCharSpace() {
        return this.charSpace;
    }

    public Graphics2D renderString(Graphics2D ctx, String str) {
        int x = this.textLoc.getX();
        int y = this.textLoc.getY();
        int iReduce = 0;
        int xPush = 0;
        int yPush = 112;
        int i = 0;
        while (i < str.length()) {
            if (this.imgs.size() != str.length()) {
                xPush = 0;
                while (xPush < this.charBlock0.length()) {
                    if (str.toUpperCase().charAt(i) == this.charBlock0.charAt(xPush)) {
                        yPush = 0;
                        break;
                    }
                    if (str.toUpperCase().charAt(i) == this.charBlock1.charAt(xPush)) {
                        yPush = 16;
                        break;
                    }
                    if (str.toUpperCase().charAt(i) == this.charBlock2.charAt(xPush)) {
                        yPush = 32;
                        break;
                    }
                    if (str.toUpperCase().charAt(i) == this.charBlock3.charAt(xPush)) {
                        yPush = 48;
                        break;
                    }
                    if (str.toUpperCase().charAt(i) == this.charBlock4.charAt(xPush)) {
                        yPush = 64;
                        break;
                    }
                    if (str.toUpperCase().charAt(i) == this.charBlock5.charAt(xPush)) {
                        yPush = 80;
                        break;
                    }
                    ++xPush;
                }
            }
            AffineTransform trans = new AffineTransform();
            if (x + this.charSize.getWidth() > this.textLoc.getX() + this.textLoc.getWidth()) {
                x = this.textLoc.getX();
                y = y + this.charSize.getHeight() + this.charSpace.getHeight();
                iReduce = i;
            } else {
                x = this.charSpace.getWidth() * (i - iReduce) + this.charSize.getWidth() * (i - iReduce);
            }
            trans.translate(x, y);
            trans.scale(this.charSize.getWidth() / 16, this.charSize.getHeight() / 16);
            trans.rotate(Math.toRadians(this.charSize.getRotation()), this.charSize.getWidth() / 2, this.charSize.getHeight() / 2);
            if (!this.image.isImageLoaded()) {
                this.image.loadImage();
            }
            if (i < this.imgs.size() && this.imgs.get(i) != null) {
                ctx.drawImage(this.imgs.get(i), trans, null);
            } else {
                if (i < this.imgs.size()) {
                    this.imgs.add(this.image.getImage().getSubimage(xPush * 16, yPush, 16, 16));
                } else {
                    this.imgs.set(i, this.image.getImage().getSubimage(xPush * 16, yPush, 16, 16));
                }
                ctx.drawImage(this.imgs.get(i), trans, null);
            }
            ++i;
        }
        return ctx;
    }

    public void setCharSize(Location charSize) {
        this.charSize = charSize;
    }

    public void setTextLocation(Location textLoc) {
        this.textLoc = textLoc;
    }

    public void setCharSpace(Location charSpace) {
        this.charSpace = charSpace;
    }
}

