/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.entitiy.block;

import com.estrelsteel.engine1.collide.CollideMap;
import com.estrelsteel.engine1.collide.CollideType;
import com.estrelsteel.engine1.entitiy.Entity;
import com.estrelsteel.engine1.entitiy.block.BlockStatus;
import com.estrelsteel.engine1.entitiy.block.BlockType;
import com.estrelsteel.engine1.world.Location;

public class Block
extends Entity {
    private BlockStatus status = BlockStatus.IDLE;

    public Block(BlockType type, Location loc) {
        super(type.getType(), loc, 10, null);
        this.setCollide(false);
    }

    public BlockStatus getStatus() {
        return this.status;
    }

    public CollideType getCollideType(CollideMap map) {
        int x = map.getCentre().getX();
        int y = map.getCentre().getY();
        Location point = this.getLocation().getRotatedPoint(this.getLocation().getX() - x, this.getLocation().getY() - y, this.getLocation().getRotation());
        point.setX(point.getX() + x);
        point.setY(point.getY() + y);
        if (map.getCollide(point.getX(), point.getY())) {
            point = this.getLocation().getRotatedPoint(this.getLocation().getX() + this.getLocation().getWidth() - x, this.getLocation().getY() + this.getLocation().getHeight() - y, this.getLocation().getRotation());
            point.setX(point.getX() + x);
            point.setY(point.getY() + y);
            if (map.getCollide(point.getX(), point.getY())) {
                return CollideType.FULL;
            }
            return CollideType.HALF;
        }
        return CollideType.NONE;
    }

    public void setStatus(BlockStatus status) {
        this.status = status;
    }
}

