/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.entitiy;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.entitiy.Animation;
import com.estrelsteel.engine1.entitiy.EntityImage;
import com.estrelsteel.engine1.menu.MenuItem;
import com.estrelsteel.engine1.world.Location;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EntityType {
    UNKNOWN(-1, "UNKNOWN", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 0, 16, 16)),
    HIDDEN(0, "HIDDEN", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 0, 16, 16)),
    RED_BLOCK(1, "RED_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(16, 0, 16, 16)),
    ORANGE_BLOCK(2, "ORANGE_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(32, 0, 16, 16)),
    YELLOW_BLOCK(3, "YELLOW_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(48, 0, 16, 16)),
    LIGHT_GREEN_BLOCK(4, "LIGHT_GREEN_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(64, 0, 16, 16)),
    GREEN_BLOCK(5, "GREEN_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(80, 0, 16, 16)),
    TURQUOISE_BLOCK(6, "TURQUOISE_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(96, 0, 16, 16)),
    AQUA_BLOCK(7, "AQUA_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(112, 0, 16, 16)),
    LIGHT_BLUE_BLOCK(8, "LIGHT_BLUE_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 16, 16, 16)),
    BLUE_BLOCK(9, "BLUE_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(16, 16, 16, 16)),
    PURPLE_BLOCK(10, "PURPLE_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(32, 16, 16, 16)),
    PINK_BLOCK(11, "PINK_BLOCK", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(48, 16, 16, 16)),
    CIRCLE_MAP(12, "CIRCLE_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/circle.png", new Location(0, 0, 256, 256)),
    PENTAGON_MAP(13, "PENTAGON_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/pentagon.png", new Location(0, 0, 256, 256)),
    DONUT_MAP(14, "DONUT_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/donut.png", new Location(0, 0, 256, 256)),
    STAR_MAP(15, "STAR_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/star.png", new Location(0, 0, 256, 256)),
    CLAW(16, "CLAW", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(0, 32, 32, 32)),
    CLAW_ARM(17, "CLAW_ARM", String.valueOf(Engine1.filesPath) + "/assets/res/img/texture.png", new Location(96, 32, 32, 32)),
    ROD_CENTRE_MAP(18, "ROD_CENTRE", String.valueOf(Engine1.filesPath) + "/assets/res/img/rod_centre.png", new Location(0, 0, 256, 256)),
    L_MAP(19, "L_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/l.png", new Location(0, 0, 256, 256)),
    BUBBLES_MAP(20, "BUBBLES_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/bubbles.png", new Location(0, 0, 256, 256)),
    BACK(21, "BACK", String.valueOf(Engine1.filesPath) + "/assets/res/img/back.png", new Location(0, 0, 256, 256)),
    ARROW_MAP(22, "ARROW_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/arrow.png", new Location(0, 0, 256, 256)),
    ROD_MAP(23, "ROD_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/rod.png", new Location(0, 0, 256, 256)),
    CAR_MAP(24, "CAR_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/car.png", new Location(0, 0, 256, 256)),
    ICE_CREAM_MAP(25, "ICE_CREAM_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/ice_cream.png", new Location(0, 0, 256, 256)),
    PIE_MAP(26, "PIE_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/pie.png", new Location(0, 0, 256, 256)),
    STAR_6_MAP(27, "STAR_6_MAP", String.valueOf(Engine1.filesPath) + "/assets/res/img/star6.png", new Location(0, 0, 256, 256));

    private int id;
    private String name;
    private EntityImage defaultImage;
    private ArrayList<Animation> animations = new ArrayList();
    private Location loc;
    private MenuItem.MenuItemType menuType;

    private EntityType(int id, String name, String src, Location loc) {
        this.id = id;
        this.name = name;
        this.loc = loc;
        this.defaultImage = new EntityImage(src, this.loc);
        this.animations = new ArrayList();
        this.animations.add(new Animation(30));
        this.animations.get(0).addImage(this.defaultImage);
        this.menuType = MenuItem.MenuItemType.UNKNOWN;
    }

    private EntityType(int id, String name, String src, Location loc, MenuItem.MenuItemType menuType) {
        this.id = id;
        this.name = name;
        this.loc = loc;
        this.defaultImage = new EntityImage(src, this.loc);
        this.animations = new ArrayList();
        this.animations.add(new Animation(30));
        this.animations.get(0).addImage(this.defaultImage);
        this.menuType = menuType;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public EntityImage getDefaultImage() {
        return this.defaultImage;
    }

    public ArrayList<Animation> getAnimations() {
        return this.animations;
    }

    public Location getLocation() {
        return this.loc;
    }

    public MenuItem.MenuItemType getMenuItemType() {
        return this.menuType;
    }

    public void addAnimation(Animation animation) {
        this.animations.add(animation);
    }

    public void removeAnimation(Animation animation) {
        this.animations.remove(animation);
    }

    public void setAnimations(ArrayList<Animation> animations) {
        this.animations = animations;
    }

    public static EntityType findByName(String name) {
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType type = entityTypeArray[n2];
            if (type.getName().equalsIgnoreCase(name)) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static EntityType findByID(int id) {
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType type = entityTypeArray[n2];
            if (type.getID() == id) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static void updateSRC(String filesPath) {
        int i = 0;
        while (i < EntityType.values().length) {
            EntityType.values()[i].setSRC(String.valueOf(filesPath) + EntityType.values()[i].getDefaultImage().getSRC());
            ++i;
        }
    }

    private void setSRC(String src) {
        this.defaultImage = new EntityImage(src, this.loc);
        this.animations.get(0).getImages().set(0, this.defaultImage);
    }
}

