/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.entitiy;

import com.estrelsteel.engine1.world.Image;
import com.estrelsteel.engine1.world.Location;
import java.awt.image.BufferedImage;

public class EntityImage
extends Image {
    private Location loc;
    private BufferedImage eImg;

    public EntityImage(String src) {
        super(src);
        this.loc = new Location(0, 0, 16, 16);
    }

    public EntityImage(String src, boolean scan) {
        super(src, scan);
        this.loc = new Location(0, 0, 16, 16);
    }

    public EntityImage(String src, Location loc) {
        super(src);
        this.loc = loc;
    }

    public EntityImage(String src, Location loc, boolean scan) {
        super(src, scan);
        this.loc = loc;
    }

    public Location getLocation() {
        return this.loc;
    }

    public BufferedImage getEntity() {
        if (!this.isImageLoaded()) {
            this.loadImage();
        }
        if (this.eImg == null) {
            this.eImg = this.getImage().getSubimage(this.loc.getX(), this.loc.getY(), this.loc.getWidth(), this.loc.getHeight());
            if (this.getScan()) {
                boolean keepScan = false;
                int x = 0;
                while (x < this.eImg.getWidth()) {
                    int y = 0;
                    while (y < this.eImg.getHeight()) {
                        if (this.eImg.getRGB(x, y) == -1310580 || this.eImg.getRGB(x, y) == -16777216) {
                            this.eImg.setRGB(x, y, 0);
                            keepScan = true;
                        }
                        ++y;
                    }
                    ++x;
                }
                if (!keepScan) {
                    this.setScan(false);
                }
            }
        }
        return this.eImg;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }
}

