/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.entitiy;

import com.estrelsteel.engine1.entitiy.Animation;
import com.estrelsteel.engine1.entitiy.EntityImage;
import com.estrelsteel.engine1.entitiy.EntityType;
import com.estrelsteel.engine1.handler.GameHandler;
import com.estrelsteel.engine1.handler.Handler;
import com.estrelsteel.engine1.world.Location;
import com.estrelsteel.engine1.world.World;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity {
    private Location loc;
    private EntityType type;
    private Handler controls;
    private int walkspeed;
    private int slowWalkspeed;
    private boolean collide;
    private String name;
    private int activeAnimation;
    private Entity equiped;
    private boolean topEquip;
    private AffineTransform trans;
    private boolean noClip = false;

    public Entity() {
        this.loc = new Location(0, 0, 64, 64);
        this.controls = new GameHandler("PLAYER");
        this.name = "NULL";
        this.activeAnimation = 0;
    }

    public Entity(EntityType type, Location loc) {
        this.type = type;
        this.loc = loc;
        this.controls = null;
        this.walkspeed = 5;
        this.slowWalkspeed = 1;
        this.collide = true;
        this.name = "NULL";
        this.activeAnimation = 0;
    }

    public Entity(EntityType type, Location loc, Handler controls) {
        this.type = type;
        this.loc = loc;
        this.controls = controls;
        this.walkspeed = 5;
        this.slowWalkspeed = 1;
        this.collide = true;
        this.name = "NULL";
        this.activeAnimation = 0;
    }

    public Entity(EntityType type, Location loc, int walkspeed, Handler controls) {
        this.type = type;
        this.loc = loc;
        this.controls = controls;
        this.walkspeed = walkspeed;
        this.slowWalkspeed = 1;
        this.collide = true;
        this.name = "NULL";
        this.activeAnimation = 0;
    }

    public Entity(EntityType type, Location loc, int walkspeed, boolean collide, Handler controls, String name) {
        this.type = type;
        this.loc = loc;
        this.controls = controls;
        this.walkspeed = walkspeed;
        this.slowWalkspeed = 1;
        this.collide = collide;
        this.name = name.trim();
        this.activeAnimation = 0;
    }

    public Location getLocation() {
        return this.loc;
    }

    public EntityType getType() {
        return this.type;
    }

    public Handler getControls() {
        return this.controls;
    }

    public int getWalkspeed() {
        return this.walkspeed;
    }

    public int getSlowWalkspeed() {
        return this.slowWalkspeed;
    }

    public boolean getCollide() {
        return this.collide;
    }

    public String getName() {
        return this.name;
    }

    public int getActiveAnimationNum() {
        return this.activeAnimation;
    }

    public Animation getCurrentAnimation() {
        if (this.activeAnimation >= this.type.getAnimations().size()) {
            --this.activeAnimation;
            return this.getCurrentAnimation();
        }
        return this.type.getAnimations().get(this.activeAnimation);
    }

    public EntityImage getCurrentImage() {
        return this.getCurrentAnimation().getImages().get(this.getCurrentAnimation().getFrame());
    }

    public Entity getEquiped() {
        return this.equiped;
    }

    public boolean getTopEquip() {
        return this.topEquip;
    }

    public AffineTransform getTransformation() {
        return this.trans;
    }

    public boolean isNoClip() {
        return this.noClip;
    }

    public boolean equals(Entity entity) {
        return this.loc.equals(entity.getLocation()) && this.type.getID() == entity.getType().getID() && entity.getWalkspeed() == this.walkspeed && entity.getName() == this.name;
    }

    public boolean basicEquals(Entity entity) {
        return this.type.getID() == entity.getType().getID() && this.name.equalsIgnoreCase(entity.getName());
    }

    public boolean moveUp(World world) {
        int walk = this.walkspeed;
        if (this.noClip || !world.doesCollide(this, new Location(this.loc.getX(), this.loc.getY() - this.walkspeed, this.loc.getWidth(), this.loc.getHeight()))) {
            this.loc.setX(this.loc.getX());
            this.loc.setY(this.loc.getY() - walk);
            return true;
        }
        if (this.noClip || !world.doesCollide(this, new Location(this.loc.getX(), this.loc.getY() - this.slowWalkspeed, this.loc.getWidth(), this.loc.getHeight()))) {
            this.loc.setX(this.loc.getX());
            this.loc.setY(this.loc.getY() - this.slowWalkspeed);
            return true;
        }
        return false;
    }

    public boolean moveDown(World world) {
        int walk = this.walkspeed;
        if (this.noClip || !world.doesCollide(this, new Location(this.loc.getX(), this.loc.getY() + this.walkspeed, this.loc.getWidth(), this.loc.getHeight()))) {
            this.loc.setX(this.loc.getX());
            this.loc.setY(this.loc.getY() + walk);
            return true;
        }
        if (this.noClip || !world.doesCollide(this, new Location(this.loc.getX(), this.loc.getY() + this.slowWalkspeed, this.loc.getWidth(), this.loc.getHeight()))) {
            this.loc.setX(this.loc.getX());
            this.loc.setY(this.loc.getY() + this.slowWalkspeed);
            return true;
        }
        return false;
    }

    public boolean moveRight(World world) {
        int walk = this.walkspeed;
        if (this.noClip || !world.doesCollide(this, new Location(this.loc.getX() + this.walkspeed, this.loc.getY(), this.loc.getWidth(), this.loc.getHeight()))) {
            this.loc.setX(this.loc.getX() + walk);
            this.loc.setY(this.loc.getY());
            return true;
        }
        if (this.noClip || !world.doesCollide(this, new Location(this.loc.getX() + this.slowWalkspeed, this.loc.getY(), this.loc.getWidth(), this.loc.getHeight()))) {
            this.loc.setX(this.loc.getX() + this.slowWalkspeed);
            this.loc.setY(this.loc.getY());
            return true;
        }
        return false;
    }

    public boolean moveLeft(World world) {
        int walk = this.walkspeed;
        if (this.noClip || !world.doesCollide(this, new Location(this.loc.getX() - this.walkspeed, this.loc.getY(), this.loc.getWidth(), this.loc.getHeight()))) {
            this.loc.setX(this.loc.getX() - walk);
            this.loc.setY(this.loc.getY());
            return true;
        }
        if (this.noClip || !world.doesCollide(this, new Location(this.loc.getX() - this.slowWalkspeed, this.loc.getY(), this.loc.getWidth(), this.loc.getHeight()))) {
            this.loc.setX(this.loc.getX() - this.slowWalkspeed);
            this.loc.setY(this.loc.getY());
            return true;
        }
        return false;
    }

    public ArrayList<String> convertToES1File(ArrayList<String> lines) {
        lines.add("new Entity :");
        lines = this.loc.convertToES1File(lines);
        lines.add("type = " + this.type.getName());
        lines.add("handler = " + this.controls.getName());
        lines.add("collide = " + this.collide);
        lines.add("walkspeed = " + this.walkspeed);
        lines.add("name = " + this.name);
        lines.add("end");
        return lines;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    public void setControls(Handler controls) {
        this.controls = controls;
    }

    public void setWalkspeed(int walkspeed) {
        this.walkspeed = walkspeed;
    }

    public void setSlowWalkspeed(int slowWalkspeed) {
        this.slowWalkspeed = slowWalkspeed;
    }

    public void setCollide(boolean collide) {
        this.collide = collide;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActiveAnimationNum(int activeAnimation) {
        this.activeAnimation = activeAnimation;
    }

    public void setEquiped(Entity equiped) {
        this.equiped = equiped;
    }

    public void setTopEquip(boolean topEquip) {
        this.topEquip = topEquip;
    }

    public void setTransformation(AffineTransform trans) {
        this.trans = trans;
    }

    public void setNoClip(boolean noClip) {
        this.noClip = noClip;
    }
}

