/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.entitiy;

import com.estrelsteel.engine1.entitiy.EntityImage;
import com.estrelsteel.engine1.sound.Effects;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Animation {
    private ArrayList<EntityImage> images = new ArrayList();
    private int frame;
    private int wait;
    private int maxWait;
    private boolean paused;
    private boolean ran;
    private Effects sfx;

    public Animation(int maxWait) {
        this.maxWait = maxWait;
        this.ran = false;
    }

    public Animation(int maxWait, Effects sfx) {
        this.maxWait = maxWait;
        this.ran = false;
        this.sfx = sfx;
    }

    public ArrayList<EntityImage> getImages() {
        return this.images;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getWait() {
        return this.wait;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public Effects getSoundEffect() {
        return this.sfx;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean hasRan() {
        return this.ran;
    }

    public boolean equals(Animation animation) {
        return this.images.equals(animation.getImages()) && this.maxWait == animation.getMaxWait();
    }

    public EntityImage run() {
        if (!this.paused && !this.ran) {
            ++this.wait;
            if (this.wait >= this.maxWait) {
                this.wait = 0;
                ++this.frame;
            }
            if (this.frame >= this.images.size()) {
                this.frame = 0;
            }
            this.ran = true;
        }
        return this.images.get(this.frame);
    }

    public void addImage(EntityImage image) {
        this.images.add(image);
    }

    public void setImages(ArrayList<EntityImage> images) {
        this.images = images;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public void setWait(int wait) {
        this.wait = wait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setRan(boolean ran) {
        this.ran = ran;
    }

    public void setSoundEffect(Effects sfx) {
        this.sfx = sfx;
    }
}

