/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.contract;

import com.estrelsteel.engine1.contract.Basic;
import com.estrelsteel.engine1.contract.MinTotalScore;
import com.estrelsteel.engine1.contract.NoColour;
import com.estrelsteel.engine1.contract.RequireData;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Requirement {
    public abstract boolean checkRequirement(RequireData var1);

    public abstract String toString();

    public static ArrayList<Requirement> create(String line) {
        String[] requirements = line.split("~");
        ArrayList<Requirement> requires = new ArrayList<Requirement>();
        String[] stringArray = requirements;
        int n = requirements.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] args = s.split("/");
            RequirementTypes type = RequirementTypes.findByID(Integer.parseInt(args[0].trim()));
            if (type == RequirementTypes.MIN_TOT_SCORE) {
                requires.add(MinTotalScore.load(s));
            } else if (type == RequirementTypes.NO_COLOUR) {
                requires.add(NoColour.load(s));
            } else if (type == RequirementTypes.BASIC) {
                requires.add(Basic.load(s));
            }
            ++n2;
        }
        return requires;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequirementTypes {
        INVALID(-1),
        MIN_TOT_SCORE(0),
        NO_COLOUR(1),
        BASIC(2);

        private int id;

        private RequirementTypes(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }

        public static RequirementTypes findByID(int id) {
            RequirementTypes[] requirementTypesArray = RequirementTypes.values();
            int n = requirementTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                RequirementTypes type = requirementTypesArray[n2];
                if (type.getID() == id) {
                    return type;
                }
                ++n2;
            }
            return INVALID;
        }
    }
}

