/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.contract;

import com.estrelsteel.engine1.contract.NoColour;
import com.estrelsteel.engine1.contract.RequireData;
import com.estrelsteel.engine1.contract.Requirement;
import com.estrelsteel.engine1.maps.Map;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contract {
    private ArrayList<Requirement> requirements;
    private String name;
    private boolean finished;
    private Map.Maps map;

    public Contract() {
        this.name = "NULL";
        this.requirements = new ArrayList();
        this.finished = false;
    }

    public Contract(String name, Map.Maps map) {
        this.name = name;
        this.requirements = new ArrayList();
        this.finished = false;
        this.map = map;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Requirement> getRequirements() {
        return this.requirements;
    }

    public Map.Maps getMap() {
        return this.map;
    }

    public static Contract create(String line) {
        Contract c = new Contract();
        String[] args = line.split("=");
        c.setName(args[0].trim());
        c.setMap(Map.Maps.findByID(Integer.parseInt(args[1].trim())));
        c.setRequirements(Requirement.create(args[2].trim()));
        return c;
    }

    public boolean checkFinished(RequireData data, boolean finished) {
        for (Requirement r : this.requirements) {
            if (!(r instanceof NoColour) && !finished || r.checkRequirement(data)) continue;
            return false;
        }
        return true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRequirements(ArrayList<Requirement> requirements) {
        this.requirements = requirements;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void setMap(Map.Maps map) {
        this.map = map;
    }
}

