/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.collide;

import com.estrelsteel.engine1.entitiy.Entity;
import com.estrelsteel.engine1.entitiy.EntityType;
import com.estrelsteel.engine1.world.Location;

public class CollideMap
extends Entity {
    private Location centre;

    public CollideMap(EntityType type, Location loc) {
        super(type, loc);
        this.centre = new Location(loc.getX() + loc.getWidth() / 2, loc.getY() + loc.getHeight() / 2);
        this.setCollide(false);
    }

    public Location getCentre() {
        return this.centre;
    }

    public boolean getCollide(double x, double y) {
        int width = this.getCurrentImage().getEntity().getWidth();
        int height = this.getCurrentImage().getEntity().getHeight();
        int trueX = (int)((double)width / ((double)this.getLocation().getWidth() / x));
        int trueY = (int)((double)height / ((double)this.getLocation().getHeight() / y));
        if (trueX < 1 || trueY < 1 || trueX >= width || trueY >= height) {
            return false;
        }
        int rgb = this.getCurrentImage().getEntity().getRGB(trueX, trueY);
        int red = (rgb & 0xFF0000) >> 16;
        int green = (rgb & 0xFF00) >> 8;
        int blue = rgb & 0xFF;
        return red <= 125 && green <= 125 && blue <= 125;
    }

    public void setCentre(Location centre) {
        this.centre = centre;
    }
}

