/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.camera;

import com.estrelsteel.engine1.camera.Camera;
import com.estrelsteel.engine1.world.Image;
import com.estrelsteel.engine1.world.Location;
import java.awt.Color;
import java.awt.Graphics;

public abstract class CameraController {
    private Camera camera;
    private double tempX;
    private double tempY;
    private double alpha = 0.0;
    private String name = "TEST";

    public CameraController(Camera camera, String name) {
        this.camera = camera;
        this.name = name;
        this.tempX = camera.getLocation().getX();
        this.tempY = camera.getLocation().getY();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public String getName() {
        return this.name;
    }

    public abstract void execute(int var1);

    public abstract void execute(int var1, double var2);

    public Camera glide(Location glideStart, Location loc, double time) {
        if (!new Location(this.camera.getLocation().getX() * -1, this.camera.getLocation().getY() * -1, 0, 0).equals(loc)) {
            double frameMoveX = (double)loc.getRawXDistance(glideStart) / time;
            double frameMoveY = (double)loc.getRawYDistance(glideStart) / time;
            this.tempX += frameMoveX;
            this.tempY += frameMoveY;
            this.camera.getLocation().setX((int)this.tempX);
            this.camera.getLocation().setY((int)this.tempY);
        }
        return this.camera;
    }

    public Graphics fadeOut(Graphics ctx, double time, int width, int height, Image img) {
        this.alpha += 255.0 / time;
        if (this.alpha > 255.0) {
            this.alpha = 255.0;
        }
        if (this.alpha < 0.0) {
            this.alpha = 0.0;
        }
        int x = 0;
        while (x < img.getImage().getWidth()) {
            int y = 0;
            while (y < img.getImage().getHeight()) {
                img.getImage().setRGB(x, y, (int)this.alpha);
                ++y;
            }
            ++x;
        }
        ctx.drawImage(img.getImage(), this.camera.getLocation().getX() - width / 2, this.camera.getLocation().getY() - height / 2, width, height, null);
        return ctx;
    }

    public Graphics fadeOut(Graphics ctx, double time, int width, int height) {
        return this.fadeOut(ctx, time, width, height, Color.BLACK);
    }

    public Graphics fadeOut(Graphics ctx, double time, int width, int height, Color colour) {
        this.alpha += 255.0 / time;
        if (this.alpha > 255.0) {
            this.alpha = 255.0;
        }
        if (this.alpha < 0.0) {
            this.alpha = 0.0;
        }
        ctx.setColor(new Color(colour.getRed(), colour.getGreen(), colour.getBlue(), (int)this.alpha));
        ctx.fillRect(this.camera.getLocation().getX() - width / 2, this.camera.getLocation().getY() - height / 2, width, height);
        return ctx;
    }

    public Graphics fadeIn(Graphics ctx, double time, int width, int height, Image img) {
        this.alpha -= 255.0 / time;
        if (this.alpha > 255.0) {
            this.alpha = 255.0;
        }
        if (this.alpha < 0.0) {
            this.alpha = 0.0;
        }
        int x = 0;
        while (x < img.getImage().getWidth()) {
            int y = 0;
            while (y < img.getImage().getHeight()) {
                img.getImage().setRGB(x, y, (int)this.alpha);
                ++y;
            }
            ++x;
        }
        ctx.drawImage(img.getImage(), this.camera.getLocation().getX() - width / 2, this.camera.getLocation().getY() - height / 2, width, height, null);
        return ctx;
    }

    public Graphics fadeIn(Graphics ctx, double time, int width, int height) {
        return this.fadeIn(ctx, time, width, height, Color.BLACK);
    }

    public Graphics fadeIn(Graphics ctx, double time, int width, int height, Color colour) {
        this.alpha -= 255.0 / time;
        if (this.alpha > 255.0) {
            this.alpha = 255.0;
        }
        if (this.alpha < 0.0) {
            this.alpha = 0.0;
        }
        ctx.setColor(new Color(colour.getRed(), colour.getGreen(), colour.getBlue(), (int)this.alpha));
        ctx.fillRect(this.camera.getLocation().getX() - width / 2, this.camera.getLocation().getY() - height / 2, width, height);
        return ctx;
    }

    public boolean hasFaded() {
        return this.alpha >= 255.0 || this.alpha <= 0.0;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }
}

