/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1.camera;

import com.estrelsteel.engine1.Engine1;
import com.estrelsteel.engine1.camera.CameraController;
import com.estrelsteel.engine1.entitiy.Entity;
import com.estrelsteel.engine1.world.Location;
import com.estrelsteel.engine1.world.World;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Camera {
    private Location loc;
    private Entity entity;
    private boolean followX;
    private boolean followY;
    private CameraController controller;

    public Camera() {
        this.loc = new Location(0, 0, 64, 64);
        this.followX = false;
        this.followY = false;
    }

    public Camera(Location loc) {
        this.loc = loc;
        this.followX = false;
        this.followY = false;
    }

    public Camera(Location loc, Entity entity) {
        this.loc = loc;
        this.entity = entity;
        this.followX = true;
        this.followY = true;
    }

    public Location getLocation() {
        return this.loc;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean getFollowX() {
        return this.followX;
    }

    public boolean getFollowY() {
        return this.followY;
    }

    public CameraController getCameraController() {
        return this.controller;
    }

    public boolean equals(Camera camera) {
        return this.loc == camera.getLocation() && this.entity == camera.getEntity() && this.followX && this.followY;
    }

    public void focus(World world) {
        if (this.entity != null) {
            if (this.followX) {
                this.loc.setX(this.entity.getLocation().getX() * -1 + Engine1.WIDTH / 2);
            }
            if (this.followY) {
                this.loc.setY(this.entity.getLocation().getY() * -1 + Engine1.HEIGHT / 2);
            }
        }
    }

    public ArrayList<String> convertToES1File(ArrayList<String> lines) {
        lines.add("new Camera :");
        lines = this.loc.convertToES1File(lines);
        if (this.entity != null) {
            lines.add("entity = " + this.entity.getName());
        }
        lines.add("followX = " + this.followX);
        lines.add("followY = " + this.followY);
        lines.add("end");
        return lines;
    }

    public void setLocation(Location loc) {
        this.loc = loc;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public void setFollowX(boolean followX) {
        this.followX = followX;
    }

    public void setFollowY(boolean followY) {
        this.followY = followY;
    }

    public void setCameraController(CameraController controller) {
        this.controller = controller;
    }
}

