/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine1;

import com.estrelsteel.engine1.camera.Camera;
import com.estrelsteel.engine1.contract.Contract;
import com.estrelsteel.engine1.contract.RequireData;
import com.estrelsteel.engine1.entitiy.Entity;
import com.estrelsteel.engine1.entitiy.EntityType;
import com.estrelsteel.engine1.entitiy.block.Block;
import com.estrelsteel.engine1.entitiy.block.BlockStatus;
import com.estrelsteel.engine1.entitiy.block.BlockType;
import com.estrelsteel.engine1.estrelian.Estrelian;
import com.estrelsteel.engine1.handler.CoreHandler;
import com.estrelsteel.engine1.handler.GameHandler;
import com.estrelsteel.engine1.handler.Handler;
import com.estrelsteel.engine1.maps.Gamemode;
import com.estrelsteel.engine1.maps.Map;
import com.estrelsteel.engine1.menu.Menu;
import com.estrelsteel.engine1.menu.MenuImage;
import com.estrelsteel.engine1.menu.MenuItem;
import com.estrelsteel.engine1.menu.MenuText;
import com.estrelsteel.engine1.menu.controller.ContractController;
import com.estrelsteel.engine1.menu.controller.FinshedContractController;
import com.estrelsteel.engine1.menu.controller.HudController;
import com.estrelsteel.engine1.menu.controller.MainMenuController;
import com.estrelsteel.engine1.saves.Profile;
import com.estrelsteel.engine1.sound.Effects;
import com.estrelsteel.engine1.world.Location;
import com.estrelsteel.engine1.world.World;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferStrategy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Engine1
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 1L;
    public static final double SCALE = 1.0;
    public static int WIDTH = 650;
    public static final int startWidth = (int)((double)WIDTH * 1.0);
    public static int HEIGHT = 650;
    public static final int startHeight = (int)((double)HEIGHT * 1.0);
    public static Dimension dimension = new Dimension((int)((double)WIDTH * 1.0), (int)((double)HEIGHT * 1.0));
    public boolean running = false;
    public boolean applet = false;
    public int tickCount = 0;
    public int frames;
    public boolean debug = false;
    private boolean hideDebugHud = false;
    private boolean showFPS = false;
    public int fps;
    public int tps;
    public int focused = 0;
    private Thread thread;
    public CoreHandler coreHandler;
    public GameHandler playerHandler = new GameHandler("PLAYER");
    public String title = "ShapeCrafter";
    public String version = "v0.1b";
    public static int build = 9;
    public long time = System.currentTimeMillis();
    public static String filesPath = "";
    private boolean appendEstrel = false;
    ArrayList<World> worlds = new ArrayList();
    public World world;
    public Camera camera = new Camera(new Location(0, 0, 0, 0));
    public ArrayList<Menu> menus = new ArrayList();
    public World multiWorld = new World((double)WIDTH * 1.0, (double)HEIGHT * 1.0);
    private Map.Maps devMap = Map.Maps.DEV;
    private Estrelian es2 = new Estrelian();
    public Gamemode gm = Gamemode.CLASSIC;
    public Map.Maps map = Map.Maps.DEV;
    public boolean canWin = false;
    public GameHandler gameHandler = new GameHandler("GAME_HANDLER");
    public Profile profile = new Profile();
    private int profileNum = 0;
    public double score = 0.0;
    public long startTime = 0L;
    public long expireTime = 10000L;
    public Block activeBlock = new Block(BlockType.getRandomBlockType(), new Location(98, 500, 64, 64, 0.0));
    public Entity claw = new Entity(EntityType.CLAW, new Location(98, 468, 128, 128));
    public Entity claw_arm = new Entity(EntityType.CLAW_ARM, new Location(226, 468, 300, 128));
    public Menu hud = new Menu("HUD", new Location(0, 0, 16, 16), new MenuImage(String.valueOf(filesPath) + "/assets/res/img/texture.png", new Location(0, 0, 16, 16)));
    private HudController hudController = new HudController(this.hud, this);
    public Menu mainMenu = new Menu("MAIN_MENU", new Location(0, 0, 16, 16), new MenuImage(String.valueOf(filesPath) + "/assets/res/img/menuHud.png", new Location(0, 0, 256, 256)));
    private MainMenuController mainMenuController = new MainMenuController(this.mainMenu, this);
    public Menu contract = new Menu("CONTRACT", new Location(0, 0, 16, 16), new MenuImage(String.valueOf(filesPath) + "/assets/res/img/texture.png", new Location(32, 64, 32, 32)));
    private ContractController contractController = new ContractController(this.contract, this);
    public Menu victory = new Menu("VICTORY", new Location(0, 0, 16, 16), new MenuImage(String.valueOf(filesPath) + "/assets/res/img/texture.png", new Location(32, 64, 32, 32)));
    private FinshedContractController victoryController = new FinshedContractController(this.victory, this);
    public Menu defeat = new Menu("DEFEAT", new Location(0, 0, 16, 16), new MenuImage(String.valueOf(filesPath) + "/assets/res/img/texture.png", new Location(32, 64, 32, 32)));
    private FinshedContractController defeatController = new FinshedContractController(this.defeat, this);
    public Menu over = new Menu("OVER", new Location(0, 0, 16, 16), new MenuImage(String.valueOf(filesPath) + "/assets/res/img/texture.png", new Location(32, 64, 32, 32)));
    private FinshedContractController overController = new FinshedContractController(this.over, this);
    public Menu hudContract = new Menu("HUD", new Location(0, 0, 16, 16), new MenuImage(String.valueOf(filesPath) + "/assets/res/img/texture.png", new Location(0, 0, 16, 16)));
    public ArrayList<Contract> contracts = new ArrayList();
    public int contractPos = 0;

    public void start() {
        String line;
        ArrayList<String> lines;
        BufferedReader br;
        FileReader fr;
        File f = new File(System.getProperty("java.class.path"));
        File dir = f.getAbsoluteFile().getParentFile();
        filesPath = dir.toString();
        if (this.appendEstrel) {
            filesPath = String.valueOf(filesPath) + "_estrelsteel";
        }
        this.profileNum = 1;
        try {
            fr = new FileReader(String.valueOf(filesPath) + "/saves/profile" + this.profileNum + ".cu1");
            br = new BufferedReader(fr);
            lines = new ArrayList<String>();
            line = br.readLine();
            while (line != null) {
                lines.add(line);
                line = br.readLine();
            }
            this.profile.load(lines);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.contractPos = this.profile.getPosition();
        try {
            fr = new FileReader(String.valueOf(filesPath) + "/assets/contracts.cu1");
            br = new BufferedReader(fr);
            lines = new ArrayList();
            line = br.readLine();
            while (line != null) {
                lines.add(line);
                line = br.readLine();
            }
            for (String s : lines) {
                this.contracts.add(Contract.create(s));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addFocusListener(this.coreHandler);
        this.camera.setFollowX(false);
        this.camera.setFollowY(false);
        this.camera.getLocation().setX(197);
        this.camera.getLocation().setY(50);
        this.claw.setCollide(false);
        this.claw.setWalkspeed(10);
        this.claw_arm.setCollide(false);
        this.claw_arm.setWalkspeed(10);
        if (!this.debug) {
            this.world = Map.Maps.DEV.getMap().load();
        } else {
            this.world = this.devMap.getMap().load();
            this.map = this.devMap;
            for (Menu m : this.menus) {
                m.setOpen(false);
            }
        }
        this.hud.addMenuItem(new MenuText(" seconds", new Location(56, 56), new Font("Menlo", 1, 16), Color.BLACK));
        this.hud.addMenuItem(new MenuText("0", new Location(56, 86), new Font("Menlo", 1, 16), Color.BLACK));
        this.hud.addMenuItem(new MenuItem(MenuItem.MenuItemType.CLOCK, new Location(16, 32, 32, 32)));
        this.hud.addMenuItem(new MenuItem(MenuItem.MenuItemType.CREDIT, new Location(16, 64, 32, 32)));
        this.hud.addMenuItem(new MenuItem(MenuItem.MenuItemType.PAINT, new Location(16, 570, 64, 64)));
        this.hud.setController(this.hudController);
        this.hud.setOpen(false, this);
        this.menus.add(this.hud);
        this.mainMenu.addMenuItem(new MenuText("Start", new Location(84, 370), new Font("Menlo", 1, 48), new Color(0, 102, 0)));
        this.mainMenu.addMenuItem(new MenuText("Quit", new Location(435, 370), new Font("Menlo", 1, 48), new Color(102, 0, 0)));
        this.mainMenu.addMenuItem(new MenuItem(MenuItem.MenuItemType.START, new Location(53, 310, 216, 86)));
        this.mainMenu.addMenuItem(new MenuItem(MenuItem.MenuItemType.QUIT, new Location(386, 310, 216, 86)));
        this.mainMenu.addMenuItem(new MenuText("Restart Progress", new Location(16, 610, 200, 32), new Font("Menlo", 1, 32), Color.BLACK));
        this.mainMenu.setController(this.mainMenuController);
        this.mainMenu.setOpen(true, this);
        this.menus.add(this.mainMenu);
        this.contract.setController(this.contractController);
        this.contract.setOpen(false, this);
        this.menus.add(this.contract);
        this.victory.addMenuItem(new MenuText("Contract Completed!", new Location(125, 90), new Font("Menlo", 1, 32), Color.BLACK));
        this.victory.addMenuItem(new MenuText("Next", new Location(125, 270, 160, 32), new Font("Menlo", 1, 32), Color.BLACK));
        this.victory.setController(this.victoryController);
        this.victory.setOpen(false, this);
        this.menus.add(this.victory);
        this.defeat.addMenuItem(new MenuText("Contract Failed!", new Location(125, 90), new Font("Menlo", 1, 32), Color.BLACK));
        this.defeat.addMenuItem(new MenuText("Next", new Location(125, 270, 160, 32), new Font("Menlo", 1, 32), Color.BLACK));
        this.defeat.setController(this.defeatController);
        this.defeat.setOpen(false, this);
        this.menus.add(this.defeat);
        this.over.addMenuItem(new MenuText("All Contracts Complete!", new Location(125, 90), new Font("Menlo", 1, 32), Color.BLACK));
        this.over.addMenuItem(new MenuText("By: EstrelSteel", new Location(140, 130), new Font("Menlo", 1, 32), Color.BLACK));
        this.over.addMenuItem(new MenuText("For: Ludum Dare 35", new Location(140, 170), new Font("Menlo", 1, 32), Color.BLACK));
        this.over.addMenuItem(new MenuText("Theme: Shapeshift", new Location(140, 210), new Font("Menlo", 1, 32), Color.BLACK));
        this.over.addMenuItem(new MenuText("Thank you for playing!", new Location(125, 290), new Font("Menlo", 1, 32), Color.BLACK));
        this.over.addMenuItem(new MenuText("Exit", new Location(125, 380, 160, 32), new Font("Menlo", 1, 32), Color.BLACK));
        this.over.setController(this.overController);
        this.over.setOpen(false, this);
        this.menus.add(this.over);
        this.updateContractMenu();
        this.hudContract.setOpen(false, this);
        this.menus.add(this.hudContract);
        this.world = this.addBasics(this.world);
        this.worlds.add(this.world);
        Handler.loadHandlers(this, this.worlds);
        EntityType.updateSRC(filesPath);
        MenuItem.MenuItemType.updateSRC(filesPath);
        for (Menu menu : this.menus) {
            menu.getMenuImage().setSRC(String.valueOf(filesPath) + menu.getMenuImage().getSRC());
        }
        this.running = true;
        this.thread = new Thread((Runnable)this, String.valueOf(this.title) + this.version + "_main");
        this.thread.start();
    }

    public void updateContractMenu() {
        this.contract.setMenuItems(new ArrayList<MenuItem>());
        this.hudContract.setMenuItems(new ArrayList<MenuItem>());
        this.contract.addMenuItem(new MenuText("Contract: " + this.contracts.get(this.contractPos).getName(), new Location(125, 90), new Font("Menlo", 1, 32), Color.BLACK));
        this.contract.addMenuItem(new MenuText("Requirements:", new Location(125, 130), new Font("Menlo", 1, 16), Color.BLACK));
        this.hudContract.addMenuItem(new MenuItem(MenuItem.MenuItemType.PAPER, new Location(16, 300, 256, 256)));
        this.hudContract.addMenuItem(new MenuText("Requirements:", new Location(75, 320), new Font("Menlo", 0, 8), Color.BLACK));
        int i = 0;
        while (i < this.contracts.get(this.contractPos).getRequirements().size()) {
            this.contract.addMenuItem(new MenuText("- " + this.contracts.get(this.contractPos).getRequirements().get(i), new Location(140, 130 + 20 * (i + 1)), new Font("Menlo", 1, 16), Color.BLACK));
            this.hudContract.addMenuItem(new MenuText("- " + this.contracts.get(this.contractPos).getRequirements().get(i), new Location(50, 320 + 12 * (i + 1)), new Font("Menlo", 0, 8), Color.BLACK));
            ++i;
        }
        this.contract.addMenuItem(new MenuText("Begin", new Location(125, 540, 160, 32), new Font("Menlo", 1, 32), Color.BLACK));
        this.contract.addMenuItem(new MenuText("Exit", new Location(125, 580, 160, 32), new Font("Menlo", 1, 32), Color.BLACK));
    }

    public World addBasics(World world) {
        world.addEntity(this.activeBlock);
        world.addEntity(this.claw);
        world.addEntity(this.claw_arm);
        world.addCamera(this.camera);
        world.setMainCamera(this.camera);
        return world;
    }

    public void stop() throws IOException {
        this.running = false;
        this.profile.setPosition(this.contractPos);
        try {
            FileWriter fw = new FileWriter(String.valueOf(filesPath) + "/saves/profile" + this.profileNum + ".cu1");
            BufferedWriter bw = new BufferedWriter(fw);
            ArrayList<String> lines = this.profile.save();
            for (String line : lines) {
                bw.write(String.valueOf(line) + "\n");
            }
            bw.flush();
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    public void run() {
        long lastTime = System.nanoTime();
        double nsPerTick = 1.6666666666666666E7;
        int ticks = 0;
        this.frames = 0;
        long lastTimer = System.currentTimeMillis();
        double delta = 0.0;
        while (this.running) {
            long now = System.nanoTime();
            delta += (double)(now - lastTime) / nsPerTick;
            lastTime = now;
            boolean shouldRender = true;
            while (delta >= 5.0) {
                ++ticks;
                if (this.focused < 2) {
                    this.tick();
                }
                delta -= 1.0;
                shouldRender = true;
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (shouldRender) {
                ++this.frames;
                if (this.focused < 2) {
                    this.render();
                }
            }
            if (System.currentTimeMillis() - lastTimer < 1000L) continue;
            lastTimer += 1000L;
            if (this.showFPS || this.debug) {
                System.out.println(String.valueOf(this.frames) + " fps, " + ticks + " tps");
            }
            this.fps = this.frames;
            this.tps = ticks;
            ticks = 0;
            this.frames = 0;
        }
    }

    public void tick() {
        ++this.tickCount;
        if (!(this.contract.isOpen() || this.mainMenu.isOpen() || this.victory.isOpen() || this.defeat.isOpen() || System.currentTimeMillis() - this.startTime < this.expireTime)) {
            this.startTime = System.currentTimeMillis();
            for (Entity e : this.world.getEntities()) {
                if (!(e instanceof Block) || ((Block)e).getStatus() != BlockStatus.PINNED) continue;
                this.score += ((Block)e).getCollideType(this.world.getCollideMaps().get(this.world.getCollideMapPosition())).getScore();
            }
            ((MenuText)this.hud.getMenuItems().get(1)).setText("" + this.score);
            if (this.world.getCollideMapPosition() + 1 >= this.world.getCollideMaps().size()) {
                this.world.setCollideMapPosition(0);
                this.hud.setOpen(false, this);
                this.hudContract.setOpen(false, this);
                if (this.contracts.get(this.contractPos).checkFinished(new RequireData(this.world, this.score), true)) {
                    ++this.contractPos;
                    if (this.contractPos >= this.contracts.size()) {
                        this.over.setOpen(true, this);
                        this.contractPos = 0;
                    } else {
                        Effects.VICTORY.getSound().play();
                        this.updateContractMenu();
                        this.victory.setOpen(true, this);
                    }
                } else {
                    Effects.DEFEAT.getSound().play();
                    this.defeat.setOpen(true, this);
                }
            } else {
                if (!this.contracts.get(this.contractPos).checkFinished(new RequireData(this.world, this.score), false)) {
                    Effects.DEFEAT.getSound().play();
                    this.hud.setOpen(false, this);
                    this.hudContract.setOpen(false, this);
                    this.defeat.setOpen(true, this);
                }
                this.world.setCollideMapPosition(this.world.getCollideMapPosition() + 1);
            }
            this.world.setEntities(new ArrayList<Entity>());
            this.world.addEntity(this.activeBlock);
            this.world.addEntity(this.claw);
            this.world.addEntity(this.claw_arm);
        }
        ((MenuText)this.hud.getMenuItems().get(0)).setText(String.valueOf((int)((this.expireTime - (System.currentTimeMillis() - this.startTime)) / 1000L)) + " seconds");
        if (GameHandler.GameControls.USE.isPressed()) {
            Effects.PLACE.getSound().play();
            this.activeBlock.setStatus(BlockStatus.values()[this.activeBlock.getStatus().ordinal() + 1]);
            GameHandler.GameControls.USE.setPressed(false);
        }
        if (this.activeBlock.getStatus() == BlockStatus.PINNED) {
            this.activeBlock = new Block(BlockType.getRandomBlockType(), new Location(98, 500, 64, 64, 0.0));
            this.world.addEntity(this.activeBlock);
            this.claw.setLocation(new Location(98, 468, 128, 128));
            this.claw_arm.setLocation(new Location(226, 468, 300, 128));
        }
        if (this.world != null) {
            this.world.getCollideMaps().get(this.world.getCollideMapPosition()).getLocation().setRotation(this.world.getCollideMaps().get(this.world.getCollideMapPosition()).getLocation().getRotation() + 1.0);
            for (Entity e : this.world.getEntities()) {
                e.getCurrentAnimation().run();
                if (!(e instanceof Block)) continue;
                if (((Block)e).getStatus() == BlockStatus.PINNED && this.tickCount % 1 == 0) {
                    e.getLocation().setRotation(e.getLocation().getRotation() + 1.0);
                }
                if (((Block)e).getStatus() != BlockStatus.MOVING) continue;
                e.moveUp(this.world);
                this.claw.moveUp(this.world);
                this.claw_arm.moveUp(this.world);
            }
            for (Entity e : this.world.getEntities()) {
                e.getCurrentAnimation().setRan(false);
            }
        }
        WIDTH = this.getWidth();
        HEIGHT = this.getHeight();
    }

    public void render() {
        BufferStrategy bs = this.getBufferStrategy();
        if (bs == null) {
            this.createBufferStrategy(3);
            return;
        }
        Graphics2D ctx = (Graphics2D)bs.getDrawGraphics();
        ctx.setColor(Color.RED);
        ctx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ctx.clearRect(0, 0, this.getWidth(), this.getHeight());
        ctx.drawImage(EntityType.BACK.getDefaultImage().getEntity(), 0, 0, WIDTH, HEIGHT, null);
        ctx.setFont(new Font("Menlo", 1, 16));
        if (this.world != null) {
            ctx = this.world.renderWorld(ctx);
        }
        if ((this.showFPS || this.debug) && !this.hideDebugHud) {
            ctx.drawString(String.valueOf(this.fps) + " fps, " + this.tps + " tps", 20, 20);
        }
        for (Menu menu : this.menus) {
            if (!menu.isOpen()) continue;
            ctx.drawImage(menu.getMenuImage().getMenuImage(), menu.getLocation().getX(), menu.getLocation().getY(), menu.getLocation().getWidth(), menu.getLocation().getHeight(), null);
            for (MenuItem item : menu.getMenuItems()) {
                if (item instanceof MenuText) {
                    ctx.setFont(((MenuText)item).getFont());
                    ctx.setColor(((MenuText)item).getColour());
                    ctx.drawString(((MenuText)item).getText(), item.getClickLocation().getX(), item.getClickLocation().getY() + item.getClickLocation().getHeight());
                    continue;
                }
                ctx.drawImage(item.getType().getMenuImage().getMenuImage(), item.getClickLocation().getX(), item.getClickLocation().getY(), item.getClickLocation().getWidth(), item.getClickLocation().getHeight(), null);
                if (!item.isTextOpen()) continue;
                int i = 0;
                while (i < item.getType().getDescription().size()) {
                    String line = item.getType().getDescription().get(i);
                    ctx.drawString(line, item.getTextLocation().getX(), item.getTextLocation().getY() + item.getLineSpace() * i);
                    ++i;
                }
            }
        }
        ctx.setColor(Color.BLACK);
        ctx.dispose();
        bs.show();
    }

    public static int stringtoint(String s) {
        return Integer.parseInt(s);
    }

    public static double stringtodouble(String s) {
        return Double.parseDouble(s);
    }
}

