/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld38.level;

import com.estrelsteel.engine2.Engine2;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.tile.Tile;
import com.estrelsteel.engine2.tile.TileType;
import com.estrelsteel.engine2.world.World;
import java.io.IOException;

public class Level
implements Saveable {
    private World world;
    private int shrinkTime;
    private int genTime;
    private int minScore;
    private double mineChance;

    public Level(World world) {
        this.world = world;
    }

    public int getShrinkTime() {
        return this.shrinkTime;
    }

    public int getGenerationTime() {
        return this.genTime;
    }

    public int getMinScore() {
        return this.minScore;
    }

    public double getMineChance() {
        return this.mineChance;
    }

    public void setShrinkTime(int shrinkTime) {
        this.shrinkTime = shrinkTime;
    }

    public void setGenerationTime(int genTime) {
        this.genTime = genTime;
    }

    public void setMinScore(int minScore) {
        this.minScore = minScore;
    }

    public void setMineChance(double mineChance) {
        this.mineChance = mineChance;
    }

    @Override
    public String getIdentifier() {
        return "LVL";
    }

    @Override
    public World load(GameFile file, int line) {
        String[] args = file.getLines().get(line).split(" ");
        if (args[0].equalsIgnoreCase(this.getIdentifier())) {
            this.shrinkTime = Integer.parseInt(args[1]);
            this.genTime = Integer.parseInt(args[2]);
            this.minScore = Integer.parseInt(args[3]);
            this.mineChance = Double.parseDouble(args[4]);
            int i = line + 1;
            while (i < file.getLines().size()) {
                if (file.getLines().get(i).equalsIgnoreCase("") || file.getLines().get(i).equalsIgnoreCase(" ")) {
                    return this.world;
                }
                GameFile part = new GameFile(String.valueOf(Engine2.devPath) + file.getLines().get(i));
                try {
                    part.setLines(part.readFile());
                    this.loadPart(part, 0);
                }
                catch (IOException e) {
                    return this.world;
                }
                ++i;
            }
        }
        return this.world;
    }

    public World loadPart(GameFile file, int line) {
        String[] args = file.getLines().get(line).split(" ");
        if (args[0].equalsIgnoreCase(this.getIdentifier())) {
            int sx = Integer.parseInt(args[1]);
            int sy = Integer.parseInt(args[2]);
            int tw = Integer.parseInt(args[3]);
            int th = Integer.parseInt(args[4]);
            int x = sx;
            int y = sy;
            ++line;
            while (line < file.getLines().size()) {
                args = file.getLines().get(line).split(" ");
                int t = 0;
                while (t < args.length) {
                    int tt = Integer.parseInt(args[t]);
                    if (tt >= 0) {
                        this.world.getObjects().add(new Tile(TileType.types.get(tt), QuickRectangle.location(x, y, tw, th)));
                    }
                    x += tw;
                    ++t;
                }
                x = sx;
                y += th;
                ++line;
            }
        }
        return this.world;
    }

    @Override
    public GameFile save(GameFile file) {
        return null;
    }
}

