/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld38.handler;

import com.estrelsteel.engine2.actor.Actor;
import com.estrelsteel.engine2.shape.collide.RectangleCollideArea;
import com.estrelsteel.engine2.shape.rectangle.AbstractedRectangle;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.world.World;
import com.estrelsteel.ld38.actor.Boat;
import com.estrelsteel.ld38.actor.Flag;
import com.estrelsteel.ld38.actor.Mine;
import com.estrelsteel.ld38.actor.Treasure;

public class TreasureHandler {
    private AbstractedRectangle range;
    private int tCount;
    private int mCount;
    private World w;
    private Rectangle tempLoc;
    private double mineChance;

    public TreasureHandler(AbstractedRectangle range, World w) {
        this.range = range;
        this.w = w;
        this.tCount = 0;
        this.mCount = 0;
        this.mineChance = 0.1;
    }

    public AbstractedRectangle getRange() {
        return this.range;
    }

    public World getWorld() {
        return this.w;
    }

    public double getMineChance() {
        return this.mineChance;
    }

    public Actor generateTreasure() {
        Actor t;
        int x = (int)(Math.random() * (this.range.getWidth() - 64.0) + this.range.getX());
        int y = (int)(Math.random() * (this.range.getHeight() - 64.0) + this.range.getY());
        this.tempLoc = QuickRectangle.location(x, y, 64.0, 64.0);
        if (Math.random() < this.mineChance) {
            t = new Mine("mine" + this.mCount, this.tempLoc);
            ++this.mCount;
        } else {
            t = new Treasure("treasure" + this.tCount, this.tempLoc);
            ++this.tCount;
        }
        if (this.w.checkCollideIgnoreDeclaration(new RectangleCollideArea(this.tempLoc), t) == null) {
            return t;
        }
        return this.generateTreasure();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Actor fishTreasure(AbstractedRectangle loc) {
        int i = 0;
        while (i < this.w.getObjects().size()) {
            if (this.w.getObjects().get(i) instanceof Treasure || this.w.getObjects().get(i) instanceof Mine || this.w.getObjects().get(i) instanceof Flag) {
                Actor t = (Actor)this.w.getObjects().get(i);
                if (this.w.checkCollideIgnoreDeclaration(new RectangleCollideArea(t.getLocation()), t) instanceof Boat) {
                    if (!(this.w.getObjects().get(i) instanceof Flag)) {
                        this.w.getObjects().remove(i);
                        --i;
                        return t;
                    }
                    this.w.getObjects().remove(i);
                    --i;
                } else if (new RectangleCollideArea(t.getLocation()).checkCollision(loc)) {
                    if (!(this.w.getObjects().get(i) instanceof Flag)) {
                        this.w.getObjects().remove(i);
                        --i;
                        return t;
                    }
                    this.w.getObjects().remove(i);
                    --i;
                }
            }
            ++i;
        }
        return null;
    }

    public void setRange(AbstractedRectangle range) {
        this.range = range;
    }

    public void setWorld(World w) {
        this.w = w;
    }

    public void setMineChance(double mineChance) {
        this.mineChance = mineChance;
    }
}

