/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld38;

import com.estrelsteel.engine2.Engine2;
import com.estrelsteel.engine2.Launcher;
import com.estrelsteel.engine2.actor.Actor;
import com.estrelsteel.engine2.actor.Camera;
import com.estrelsteel.engine2.events.listener.RenderListener;
import com.estrelsteel.engine2.events.listener.StartListener;
import com.estrelsteel.engine2.events.listener.StopListener;
import com.estrelsteel.engine2.events.listener.TickListener;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.grid.PixelGrid;
import com.estrelsteel.engine2.image.Image;
import com.estrelsteel.engine2.point.AbstractedPoint;
import com.estrelsteel.engine2.point.Point2;
import com.estrelsteel.engine2.point.PointMaths;
import com.estrelsteel.engine2.shape.collide.PerspectiveRectangleArea;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.sound.SFX;
import com.estrelsteel.engine2.tile.Tile;
import com.estrelsteel.engine2.tile.TileType;
import com.estrelsteel.engine2.window.WindowSettings;
import com.estrelsteel.engine2.world.World;
import com.estrelsteel.ld38.GameState;
import com.estrelsteel.ld38.actor.Arrow;
import com.estrelsteel.ld38.actor.Boat;
import com.estrelsteel.ld38.actor.Flag;
import com.estrelsteel.ld38.actor.Mine;
import com.estrelsteel.ld38.actor.Treasure;
import com.estrelsteel.ld38.actor.WhirlPool;
import com.estrelsteel.ld38.actor.WorldText;
import com.estrelsteel.ld38.handler.KeyboardHandler;
import com.estrelsteel.ld38.handler.MouseHandler;
import com.estrelsteel.ld38.handler.TreasureHandler;
import com.estrelsteel.ld38.level.Level;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;

public class LD38
implements StartListener,
StopListener,
TickListener,
RenderListener {
    private Launcher l = new Launcher();
    private GameFile settings;
    private KeyboardHandler key;
    private MouseHandler mouse;
    private World w;
    private Boat boat;
    private GameState gs;
    private GameState.SubState ss;
    private WhirlPool wp;
    private AbstractedPoint boat_centre;
    private Rectangle npLoc;
    private Tile water;
    private TreasureHandler th;
    private GameFile levelFile;
    private Level lvl;
    private int activeLvl;
    private int maxLvl;
    private Image title;
    private int waterLvl;
    private int shrinkTime;
    private long lastReduction;
    private int genTime;
    private long lastGeneration;
    private long startGame;
    private int secLeft;
    private double score;
    private double minScore;
    private boolean endless;
    private boolean canEndless;
    private double highscore;
    private int round;

    public static void main(String[] args) {
        new LD38();
    }

    public LD38() {
        Rectangle size = System.getProperty("os.name").startsWith("Windows") ? QuickRectangle.location(0.0, 0.0, 630.0, 630.0) : QuickRectangle.location(0.0, 0.0, 640.0, 640.0);
        this.key = new KeyboardHandler(this);
        this.mouse = new MouseHandler();
        this.l.getEngine().setWindowSettings(new WindowSettings(size, "Treasure Hunter - EstrelSteel", "v1.0a", 0));
        this.l.getEngine().START_EVENT.addListener(this);
        this.l.getEngine().STOP_EVENT.addListener(this);
        this.l.getEngine().RENDER_EVENT.addListener(this);
        this.l.getEngine().TICK_EVENT.addListener(this);
        this.l.getEngine().addKeyListener(this.key);
        this.l.getEngine().addMouseListener(this.mouse);
        this.l.getEngine().addMouseMotionListener(this.mouse);
        this.l.getEngine();
        Engine2.development = true;
        this.l.getEngine();
        Engine2.devPath = GameFile.getCurrentPath();
        this.l.boot();
    }

    @Override
    public void start() {
        TileType tt = new TileType(-1, "null");
        tt.load(new GameFile(String.valueOf(Engine2.devPath) + "/res/tiles.txt"), 0);
        new SFX().load(new GameFile(String.valueOf(Engine2.devPath) + "/res/sounds.txt"), 0);
        this.settings = new GameFile(String.valueOf(Engine2.devPath) + "/res/settings.txt");
        try {
            this.settings.setLines(this.settings.readFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.settings.getLines().size() > 0) {
            this.activeLvl = Integer.parseInt(this.settings.getLines().get(0));
            this.score = Double.parseDouble(this.settings.getLines().get(1));
            this.canEndless = Boolean.parseBoolean(this.settings.getLines().get(2));
            this.maxLvl = Integer.parseInt(this.settings.getLines().get(3));
            this.highscore = Double.parseDouble(this.settings.getLines().get(4));
        }
        this.endless = false;
        this.round = 1;
        this.title = this.activeLvl == 0 ? (this.canEndless ? new Image(String.valueOf(Engine2.devPath) + "/res/img/title3.png") : new Image(String.valueOf(Engine2.devPath) + "/res/img/title0.png")) : (this.activeLvl > 0 && !this.canEndless ? new Image(String.valueOf(Engine2.devPath) + "/res/img/title1.png") : new Image(String.valueOf(Engine2.devPath) + "/res/img/title2.png"));
        this.gs = GameState.MENU;
        this.ss = GameState.SubState.MAIN;
    }

    public void menuInteract(int key) {
        if (this.gs == GameState.MENU && this.ss == GameState.SubState.MAIN) {
            if (key == 1) {
                this.endless = false;
                try {
                    this.loadLevel(this.activeLvl);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (key == 2) {
                this.activeLvl = 0;
                this.score = 0.0;
                try {
                    this.loadLevel(this.activeLvl);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (key == 3 && this.canEndless) {
                this.score = 0.0;
                this.endless = true;
                try {
                    this.loadLevel(-98);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (key == -1) {
            this.gs = GameState.MENU;
            this.ss = GameState.SubState.MAIN;
        }
    }

    public void loadLevel(int lvlnum) throws IOException {
        this.w = new World(new PixelGrid());
        this.boat = new Boat("player", QuickRectangle.location(320.0, 320.0, 64.0, 64.0));
        this.wp = new WhirlPool("whirlpool", QuickRectangle.location(640.0, 640.0, 128.0, 128.0));
        this.th = new TreasureHandler(QuickRectangle.location(320.0, 320.0, 1216.0, 960.0), this.w);
        this.levelFile = new GameFile(String.valueOf(Engine2.devPath) + "/res/lvl/lvl" + lvlnum + ".txt");
        this.levelFile.setLines(this.levelFile.readFile());
        this.lvl = new Level(this.w);
        this.w = this.lvl.load(this.levelFile, 0);
        this.shrinkTime = this.lvl.getShrinkTime();
        this.lastReduction = System.currentTimeMillis();
        this.genTime = this.lvl.getGenerationTime();
        this.lastGeneration = System.currentTimeMillis();
        this.startGame = System.currentTimeMillis();
        this.score -= this.minScore;
        if (this.score < 0.0) {
            this.score = 0.0;
        }
        this.minScore = this.lvl.getMinScore();
        this.th.setMineChance(this.lvl.getMineChance());
        this.wp.setRunningAnimationNumber(1);
        this.w.getObjects().add(this.wp);
        this.w.getObjects().add(this.boat);
        this.w.getCameras().add(0, new Camera("player_cam", new Point2(0.0, 0.0, new PixelGrid())));
        this.w.setMainCamera(this.w.getCameras().get(0));
        this.waterLvl = 14;
        this.water = new Tile(TileType.types.get(this.waterLvl), QuickRectangle.location(0.0, 0.0, 640.0, 640.0));
        this.water.getRunningAnimation().getCurrentImage().loadImage();
        this.secLeft = (int)(((long)(this.shrinkTime * 4) - (System.currentTimeMillis() - this.startGame)) / 1000L);
        this.gs = GameState.PLAYING;
        this.ss = GameState.SubState.PLAYING;
        if (lvlnum == 0) {
            this.loadTutorial(1);
        }
        if (this.endless) {
            System.out.println(0.14285714285714285 * Math.pow(1.5, this.round) + 5.0);
            this.minScore = Math.floor(0.14285714285714285 * Math.pow(1.5, this.round) + 5.0);
            this.shrinkTime = (2 * this.round + 10) * 1000;
            this.gs = GameState.MENU;
            this.ss = GameState.SubState.ENDLESS_START;
        }
    }

    public void loadTutorial(int num) {
        if (num == 1) {
            this.ss = GameState.SubState.TUTORIAL_1;
            this.w.getObjects().add(0, new WorldText("tut1", QuickRectangle.location(340.0, 480.0, 184.0, 44.0), 0));
            this.w.getObjects().add(0, new WorldText("tut2", QuickRectangle.location(640.0, 480.0, 294.0, 63.0), 1));
            this.w.getObjects().add(new Arrow("treasure_arrow", QuickRectangle.location(750.0, 310.0, 64.0, 64.0), 0));
            this.w.getObjects().add(0, new Treasure("tut_treasure0", QuickRectangle.location(750.0, 380.0, 64.0, 64.0)));
            this.w.getObjects().add(0, new WorldText("tut3", QuickRectangle.location(1000.0, 480.0, 195.0, 63.0), 2));
            this.w.getObjects().add(0, new WorldText("tut6", QuickRectangle.location(990.0, 550.0, 224.0, 82.0), 5));
            this.w.getObjects().add(0, new Mine("tut_mine0", QuickRectangle.location(1060.0, 380.0, 64.0, 64.0)));
            this.w.getObjects().add(new Arrow("mine_arrow", QuickRectangle.location(1060.0, 310.0, 64.0, 64.0), 1));
            this.w.getObjects().add(0, new WorldText("tut4", QuickRectangle.location(1250.0, 480.0, 254.0, 82.0), 3));
            this.w.getObjects().add(0, new WorldText("tut5", QuickRectangle.location(1600.0, 480.0, 204.0, 82.0), 4));
            this.w.getObjects().add(new Arrow("wp_arrow", QuickRectangle.location(1672.0, 310.0, 64.0, 64.0), 0));
            this.wp.setLocation(QuickRectangle.location(1640.0, 340.0, 128.0, 128.0));
        }
    }

    @Override
    public void stop() {
        if (this.activeLvl < 0) {
            this.activeLvl = 0;
        }
        if (this.settings.getLines().size() > 0) {
            this.settings.getLines().set(0, String.valueOf(this.activeLvl));
            this.settings.getLines().set(2, String.valueOf(this.canEndless));
            this.settings.getLines().set(3, String.valueOf(this.maxLvl));
            this.settings.getLines().set(4, String.valueOf(this.highscore));
        }
        try {
            this.settings.saveFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void interact() {
        if (this.gs == GameState.PLAYING) {
            Actor t = this.th.fishTreasure(this.boat.getLocation());
            if (t != null) {
                if (t instanceof Treasure) {
                    this.score += 1.0;
                    SFX.sounds.get(1).play();
                    if (this.ss == GameState.SubState.TUTORIAL_1) {
                        int i = 0;
                        while (i < this.w.getObjects().size()) {
                            if (this.w.getObjects().get(i) instanceof Arrow && ((Arrow)this.w.getObjects().get(i)).getName().equalsIgnoreCase("treasure_arrow")) {
                                this.w.getObjects().remove(i);
                                --i;
                            }
                            ++i;
                        }
                    }
                } else if (t instanceof Mine) {
                    this.score -= 5.0;
                    SFX.sounds.get(0).play();
                    if (this.ss == GameState.SubState.TUTORIAL_1) {
                        int i = 0;
                        while (i < this.w.getObjects().size()) {
                            if (this.w.getObjects().get(i) instanceof Arrow && ((Arrow)this.w.getObjects().get(i)).getName().equalsIgnoreCase("mine_arrow")) {
                                this.w.getObjects().remove(i);
                                --i;
                            }
                            ++i;
                        }
                        this.gs = GameState.MENU;
                        this.ss = GameState.SubState.FAIL_DIRECTIONS;
                    }
                }
            } else if (this.wp.canEscape(this.boat)) {
                this.gs = GameState.MENU;
                this.ss = this.score >= this.minScore ? GameState.SubState.ESCAPE : GameState.SubState.FAIL_SCORE;
            }
        } else if (this.gs == GameState.MENU) {
            if (this.ss == GameState.SubState.ESCAPE) {
                if (!this.endless) {
                    try {
                        ++this.activeLvl;
                        if (this.activeLvl >= this.maxLvl) {
                            this.activeLvl = -99;
                            this.loadLevel(this.activeLvl);
                            this.gs = GameState.MENU;
                            this.ss = GameState.SubState.CREDITS;
                        } else {
                            this.loadLevel(this.activeLvl);
                        }
                        if (this.settings.getLines().size() > 0) {
                            this.settings.getLines().set(1, String.valueOf(this.score));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    ++this.round;
                    this.minScore = Math.floor(0.14285714285714285 * Math.pow(1.5, this.round) + 5.0);
                    this.shrinkTime = (2 * this.round + 10) * 1000;
                    this.gs = GameState.MENU;
                    this.ss = GameState.SubState.ENDLESS_START;
                }
            } else if (this.ss == GameState.SubState.ENDLESS_START) {
                try {
                    this.loadLevel(-98);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.gs = GameState.PLAYING;
                this.ss = GameState.SubState.PLAYING;
            } else if (this.ss == GameState.SubState.FAIL_NO_WATER || this.ss == GameState.SubState.FAIL_SCORE || this.ss == GameState.SubState.FAIL_DIRECTIONS) {
                if (!this.endless) {
                    try {
                        this.loadLevel(this.activeLvl);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    if (this.score > this.highscore) {
                        this.highscore = this.score;
                    }
                    this.gs = GameState.MENU;
                    this.ss = GameState.SubState.MAIN;
                }
            } else if (this.ss == GameState.SubState.CREDITS) {
                this.ss = GameState.SubState.MAIN;
                this.canEndless = true;
            }
        }
    }

    public void placeFlag() {
        if (this.gs == GameState.PLAYING && (this.ss == GameState.SubState.PLAYING || this.ss == GameState.SubState.TUTORIAL_1)) {
            this.w.getObjects().add(0, new Flag("flag", QuickRectangle.location(this.boat.getLocation().getX(), this.boat.getLocation().getY(), 64.0, 64.0), 2));
            SFX.sounds.get(2).play();
        }
    }

    @Override
    public Graphics2D render(Graphics2D ctx) {
        if (this.ss != GameState.SubState.MAIN) {
            ctx.drawImage(this.water.getRunningAnimation().getCurrentImage().getImage(), 0, 0, 640, 640, null);
            this.boat_centre = PointMaths.getCentre(this.boat.getLocation());
            this.w.getMainCamera().getLocation().setX(this.boat_centre.getX() - this.l.getEngine().getWindowSettings().getRectangle().getWidth() / 2.0);
            this.w.getMainCamera().getLocation().setY(this.boat_centre.getY() - this.l.getEngine().getWindowSettings().getRectangle().getHeight() / 2.0);
            ctx = this.w.renderWorld(ctx);
        }
        if (this.gs == GameState.PLAYING && this.ss != GameState.SubState.TUTORIAL_1 && this.activeLvl != -99) {
            ctx.setFont(new Font("Menlo", 1, 12));
            ctx.setColor(Color.BLACK);
            ctx.fillRect(18, 18, 604, 34);
            ctx.setColor(Color.RED);
            ctx.fillRect(20, 20, 600, 30);
            ctx.setColor(Color.GREEN);
            ctx.fillRect(20, 20, (int)(600.0 - 600.0 * ((double)(System.currentTimeMillis() - this.startGame) / (double)(this.shrinkTime * 4))), 30);
            ctx.setColor(Color.BLACK);
            if (this.secLeft > 1) {
                ctx.drawString(String.valueOf(this.secLeft) + " seconds remaining", 25, 40);
            } else if (this.secLeft == 1) {
                ctx.drawString("1 second remaining", 25, 40);
            } else {
                ctx.drawString("0 seconds remaining", 25, 40);
            }
            ctx.setColor(Color.WHITE);
            ctx.fillRect(20, 570, 100, 50);
            ctx.setColor(Color.BLACK);
            ctx.drawString("MinScore: " + (int)this.minScore, 25, 590);
            ctx.drawString("Score: " + (int)this.score, 25, 610);
            if (this.endless) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(500, 570, 120, 50);
                ctx.setColor(Color.BLACK);
                ctx.drawString("Best round: " + (int)this.highscore, 505, 590);
                ctx.drawString("Round: " + this.round, 505, 610);
            } else if (this.activeLvl == 1) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(20, 55, 470, 40);
                ctx.fillRect(140, 580, 390, 40);
                ctx.setColor(Color.BLACK);
                ctx.drawString("This meter indicates how long until all the water is gone.", 25, 70);
                ctx.drawString("Make sure to leave through the whirlpool before this reaches zero.", 25, 85);
                ctx.drawString("Make sure you get the minimum score before you escape.", 145, 595);
                ctx.drawString("Any extra score carries over to the next level.", 145, 610);
            }
        } else if (this.gs == GameState.MENU) {
            if (this.ss == GameState.SubState.CREDITS) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(25, 166, 595, 90);
                ctx.fillRect(200, 415, 255, 60);
                ctx.fillRect(195, 515, 265, 60);
                ctx.setColor(Color.BLACK);
                ctx.setFont(new Font("Menlo", 1, 64));
                ctx.drawString("Treasure Hunter", 30, 235);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("By: EstrelSteel", 250, 430);
                ctx.drawString("For: Ludum Dare 38 Compo", 210, 450);
                ctx.drawString("Theme: A Small World", 225, 470);
                ctx.drawString("Endless mode unlocked.", 215, 530);
                ctx.drawString("Press [SPACE] to continue", 200, 560);
            } else if (this.ss == GameState.SubState.ESCAPE) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(177, 166, 285, 90);
                ctx.fillRect(260, 410, 115, 32);
                ctx.fillRect(190, 440, 260, 32);
                ctx.setColor(Color.BLACK);
                ctx.setFont(new Font("Menlo", 1, 64));
                ctx.drawString("Escaped", 182, 235);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("Score: " + (int)this.score, 275, 430);
                ctx.drawString("Press [SPACE] to continue", 195, 460);
            } else if (this.ss == GameState.SubState.ENDLESS_START) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(165, 166, 320, 90);
                ctx.fillRect(260, 410, 115, 32);
                ctx.fillRect(250, 445, 130, 32);
                ctx.fillRect(190, 480, 260, 32);
                ctx.setColor(Color.BLACK);
                ctx.setFont(new Font("Menlo", 1, 64));
                String r = String.valueOf(this.round);
                if (this.round / 10 == 0) {
                    r = "0" + this.round;
                }
                ctx.drawString("Round " + r, 170, 225);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("Start", 300, 250);
                ctx.drawString("Score: " + (int)this.score, 275, 430);
                ctx.drawString("MinScore: " + (int)this.minScore, 255, 465);
                ctx.drawString("Press [SPACE] to continue", 195, 500);
            } else if (this.ss == GameState.SubState.FAIL_NO_WATER) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(177, 166, 285, 90);
                ctx.fillRect(260, 410, 115, 32);
                ctx.setColor(Color.BLACK);
                ctx.setFont(new Font("Menlo", 1, 64));
                ctx.drawString("Failed", 200, 225);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("No Water Remaining", 225, 245);
                ctx.drawString("Score: " + (int)this.score, 270, 430);
                if (!this.endless) {
                    ctx.setColor(Color.WHITE);
                    ctx.fillRect(190, 440, 260, 32);
                    ctx.setColor(Color.BLACK);
                    ctx.drawString("Press [SPACE] to retry", 205, 460);
                } else {
                    ctx.setColor(Color.WHITE);
                    ctx.fillRect(190, 460, 260, 32);
                    ctx.fillRect(260, 430, 115, 32);
                    ctx.setColor(Color.BLACK);
                    ctx.drawString("Round: " + this.round, 270, 450);
                    ctx.drawString("Press [SPACE] to quit", 215, 480);
                }
            } else if (this.ss == GameState.SubState.FAIL_SCORE) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(177, 166, 285, 90);
                ctx.fillRect(260, 410, 115, 32);
                ctx.setColor(Color.BLACK);
                ctx.setFont(new Font("Menlo", 1, 64));
                ctx.drawString("Failed", 200, 225);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("Not Enough Score", 235, 245);
                ctx.drawString("Score: " + (int)this.score, 270, 430);
                if (!this.endless) {
                    ctx.setColor(Color.WHITE);
                    ctx.fillRect(190, 440, 260, 32);
                    ctx.setColor(Color.BLACK);
                    ctx.drawString("Press [SPACE] to retry", 205, 460);
                } else {
                    ctx.setColor(Color.WHITE);
                    ctx.fillRect(190, 460, 260, 32);
                    ctx.fillRect(260, 430, 115, 32);
                    ctx.setColor(Color.BLACK);
                    ctx.drawString("Round: " + this.round, 270, 450);
                    ctx.drawString("Press [SPACE] to quit", 215, 480);
                }
            } else if (this.ss == GameState.SubState.FAIL_DIRECTIONS) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(177, 166, 285, 90);
                ctx.fillRect(260, 410, 115, 32);
                ctx.setColor(Color.BLACK);
                ctx.setFont(new Font("Menlo", 1, 64));
                ctx.drawString("Failed", 200, 225);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("Didn't Listen to Directions", 186, 245);
                ctx.drawString("Score: " + (int)this.score, 270, 430);
                if (!this.endless) {
                    ctx.setColor(Color.WHITE);
                    ctx.fillRect(190, 440, 260, 32);
                    ctx.setColor(Color.BLACK);
                    ctx.drawString("Press [SPACE] to retry", 205, 460);
                } else {
                    ctx.setColor(Color.WHITE);
                    ctx.fillRect(190, 460, 260, 32);
                    ctx.fillRect(260, 430, 115, 32);
                    ctx.setColor(Color.BLACK);
                    ctx.drawString("Round: " + this.round, 270, 450);
                    ctx.drawString("Press [SPACE] to quit", 215, 480);
                }
            } else if (this.ss == GameState.SubState.MAIN) {
                if (!this.title.isImageLoaded()) {
                    this.title.loadImage();
                }
                ctx.drawImage(this.title.getImage(), 0, 0, 640, 640, null);
            }
        }
        return ctx;
    }

    @Override
    public void tick() {
        int i;
        if (this.gs == GameState.PLAYING) {
            if (this.key.up) {
                this.npLoc = QuickRectangle.location(this.boat.getLocation().getX(), this.boat.getLocation().getY() - this.boat.getWalkspeed(), this.boat.getLocation().getWidth(), this.boat.getLocation().getHeight());
                this.boat.setRunningAnimationNumber(2);
                if (this.w.checkCollide(new PerspectiveRectangleArea(this.npLoc, 0.3), this.boat) == null) {
                    this.boat.setLocation(this.npLoc);
                }
            }
            if (this.key.down) {
                this.npLoc = QuickRectangle.location(this.boat.getLocation().getX(), this.boat.getLocation().getY() + this.boat.getWalkspeed(), this.boat.getLocation().getWidth(), this.boat.getLocation().getHeight());
                this.boat.setRunningAnimationNumber(3);
                if (this.w.checkCollide(new PerspectiveRectangleArea(this.npLoc, 0.3), this.boat) == null) {
                    this.boat.setLocation(this.npLoc);
                }
            }
            if (this.key.right) {
                this.npLoc = QuickRectangle.location(this.boat.getLocation().getX() + this.boat.getWalkspeed(), this.boat.getLocation().getY(), this.boat.getLocation().getWidth(), this.boat.getLocation().getHeight());
                this.boat.setRunningAnimationNumber(1);
                if (this.w.checkCollide(new PerspectiveRectangleArea(this.npLoc, 0.3), this.boat) == null) {
                    this.boat.setLocation(this.npLoc);
                }
            }
            if (this.key.left) {
                this.npLoc = QuickRectangle.location(this.boat.getLocation().getX() - this.boat.getWalkspeed(), this.boat.getLocation().getY(), this.boat.getLocation().getWidth(), this.boat.getLocation().getHeight());
                this.boat.setRunningAnimationNumber(0);
                if (this.w.checkCollide(new PerspectiveRectangleArea(this.npLoc, 0.3), this.boat) == null) {
                    this.boat.setLocation(this.npLoc);
                }
            }
            this.boat.getRunningAnimation().run();
        }
        if (System.currentTimeMillis() - this.lastReduction >= (long)this.shrinkTime && this.gs == GameState.PLAYING) {
            int newWaterLevel = this.water.getType().getID() - 1;
            if (newWaterLevel == 10) {
                newWaterLevel = 2;
                this.gs = GameState.MENU;
                this.ss = GameState.SubState.FAIL_NO_WATER;
                this.wp.setRunningAnimationNumber(2);
            } else if (newWaterLevel == 1) {
                newWaterLevel = 2;
            }
            this.water = new Tile(TileType.types.get(newWaterLevel), this.water.getLocation());
            this.lastReduction = System.currentTimeMillis();
            if (!this.water.getRunningAnimation().getCurrentImage().isImageLoaded()) {
                this.water.getRunningAnimation().getCurrentImage().loadImage();
            }
        }
        if (System.currentTimeMillis() - this.lastGeneration >= (long)this.genTime && this.gs == GameState.PLAYING) {
            this.w.getObjects().add(0, this.th.generateTreasure());
            this.lastGeneration = System.currentTimeMillis();
        }
        if (this.gs == GameState.MENU && this.ss == GameState.SubState.FAIL_NO_WATER) {
            i = 0;
            while (i < this.w.getObjects().size()) {
                if (this.w.getObjects().get(i) instanceof Treasure || this.w.getObjects().get(i) instanceof Mine) {
                    ((Actor)this.w.getObjects().get(i)).setRunningAnimationNumber(1);
                }
                ++i;
            }
        }
        if (this.gs != GameState.MENU && this.ss != GameState.SubState.MAIN) {
            i = 0;
            while (i < this.w.getObjects().size()) {
                if (this.w.getObjects().get(i) instanceof Treasure || this.w.getObjects().get(i) instanceof Mine || this.w.getObjects().get(i) instanceof Arrow || this.w.getObjects().get(i) instanceof Flag) {
                    ((Actor)this.w.getObjects().get(i)).getRunningAnimation().run();
                }
                ++i;
            }
            this.secLeft = (int)(((long)(this.shrinkTime * 4) - (System.currentTimeMillis() - this.startGame)) / 1000L);
            this.wp.getRunningAnimation().run();
            this.w.sortObjects();
        }
    }
}

