/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.tile;

import com.estrelsteel.engine2.actor.Actor;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.tile.TileType;

public class Tile
extends Actor
implements Saveable {
    private TileType type;

    public Tile(TileType type, Rectangle loc) {
        super("TILE", loc);
        this.setSortable(false);
        this.type = type;
        this.getAnimations().add(type.getAnimation());
        this.setRunningAnimationNumber(0);
        this.getCollision().setCollide(type.doesCollide());
    }

    public TileType getType() {
        return this.type;
    }

    public void setType(TileType type) {
        this.type = type;
        this.setRunningAnimationNumber(type.getID());
        this.getCollision().setCollide(type.doesCollide());
    }

    @Override
    public String getIdentifier() {
        return "GTS";
    }

    @Override
    public Renderable load(GameFile file, int line) {
        String[] args = file.getLines().get(line).split(" ");
        Tile tile = new Tile(TileType.types.get(0), QuickRectangle.location(0.0, 0.0, 0.0, 0.0));
        if (args[0].trim().equalsIgnoreCase(this.getIdentifier())) {
            tile.setType(TileType.types.get(Integer.parseInt(args[2].trim())));
            tile.setLocation(QuickRectangle.location(Double.parseDouble(args[3].trim()), Double.parseDouble(args[4].trim()), Double.parseDouble(args[5].trim()), Double.parseDouble(args[6].trim())));
            return tile;
        }
        return tile;
    }

    @Override
    public GameFile save(GameFile file) {
        file.getLines().add(String.valueOf(this.getIdentifier()) + " " + this.type.getID() + " " + this.getLocation().getX() + " " + this.getLocation().getY() + " " + this.getLocation().getWidth() + " " + this.getLocation().getHeight());
        return file;
    }
}

