/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.shape;

import com.estrelsteel.engine2.point.AbstractedPoint;
import java.awt.geom.AffineTransform;

public class Rotation {
    private double degrees;
    private double radians;
    private AbstractedPoint centre;

    public Rotation(double degrees) {
        this.degrees = degrees;
        this.radians = Math.toRadians(degrees);
        this.centre = null;
    }

    public Rotation(double degrees, AbstractedPoint centre) {
        this.degrees = degrees;
        this.radians = Math.toRadians(degrees);
        this.centre = centre;
    }

    public double getDegrees() {
        return this.degrees;
    }

    public double getRadians() {
        return this.radians;
    }

    public AbstractedPoint getCentre() {
        return this.centre;
    }

    public AffineTransform applyRotation(AffineTransform trans) {
        trans.rotate(this.radians, this.centre.getX(), this.centre.getY());
        return trans;
    }

    public boolean equals(Object other) {
        return this.degrees == ((Rotation)other).getDegrees() && this.centre.equals(((Rotation)other).getCentre());
    }

    public void setDegrees(double degrees) {
        this.degrees = degrees;
        this.radians = Math.toRadians(this.degrees);
    }

    public void setRadians(double radians) {
        this.radians = radians;
        this.degrees = Math.toDegrees(this.radians);
    }

    public void setCentre(AbstractedPoint centre) {
        this.centre = centre;
    }
}

