/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.setting;

import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.setting.BaseSetting;
import java.io.IOException;
import java.util.ArrayList;

public class Settings
implements Saveable {
    private String name;
    private String path;
    private ArrayList<BaseSetting> settings;

    public Settings(String name, String path) {
        this.name = name;
        this.path = path;
        this.settings = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public ArrayList<BaseSetting> getSettings() {
        return this.settings;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setSettings(ArrayList<BaseSetting> settings) {
        this.settings = settings;
    }

    @Override
    public String getIdentifier() {
        return "SET";
    }

    public BaseSetting findSetting(String name) {
        for (BaseSetting s : this.settings) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    public Settings load() {
        GameFile file = new GameFile(this.path);
        try {
            file.setLines(file.readFile());
            return this.load(file, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Settings load(GameFile file, int line) {
        if (file.getLines().get(line).equalsIgnoreCase(this.getIdentifier())) {
            if (BaseSetting.types == null) {
                BaseSetting.loadTypes();
            }
            ++line;
            while (line < file.getLines().size()) {
                for (BaseSetting setting : BaseSetting.types) {
                    if (!setting.getIdentifier().equalsIgnoreCase(file.getLines().get(line).substring(0, 3))) continue;
                    this.settings.add(setting.load(file, line));
                }
                ++line;
            }
        }
        return this;
    }

    public GameFile save() {
        GameFile file = new GameFile(this.path);
        return this.save(file);
    }

    @Override
    public GameFile save(GameFile file) {
        for (BaseSetting s : this.settings) {
            s.save(file);
        }
        return file;
    }
}

