/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.setting;

import com.estrelsteel.engine2.setting.ConsoleMessage;
import java.util.ArrayList;

public class Console {
    private String name;
    private boolean debug;
    private ArrayList<ConsoleMessage> msgs;

    public Console(String name, boolean debug) {
        this.name = name;
        this.debug = debug;
        this.msgs = new ArrayList();
    }

    public ArrayList<ConsoleMessage> getMessages() {
        return this.msgs;
    }

    public void addMessage(ConsoleMessage msg) {
        String str = "[" + this.name + "] ";
        if (this.debug && msg.isDebug()) {
            str = String.valueOf(str) + "[DEBUG] ";
        }
        if (msg.isUrgent()) {
            System.err.println(String.valueOf(str) + msg.getMessage());
        } else {
            System.out.println(String.valueOf(str) + msg.getMessage());
        }
        this.msgs.add(msg);
    }

    public void addMessage(String s, boolean urgent, boolean debug) {
        ConsoleMessage msg = new ConsoleMessage(s, urgent, debug);
        String str = "[" + this.name + "] ";
        if (debug && msg.isDebug()) {
            str = String.valueOf(str) + "[DEBUG] ";
        }
        if (msg.isUrgent()) {
            System.err.println(String.valueOf(str) + msg.getMessage());
        } else {
            System.out.println(String.valueOf(str) + msg.getMessage());
        }
        this.msgs.add(msg);
    }

    public void setMessages(ArrayList<ConsoleMessage> msgs) {
        this.msgs = msgs;
    }
}

