/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class Image {
    private BufferedImage img;
    private String src;

    public Image(String src) {
        this.src = src;
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public String getSRC() {
        return this.src;
    }

    public boolean equals(Object other) {
        return this.src.equals(((Image)other).getSRC());
    }

    public void loadImage() {
        InputStream is = this.getClass().getResourceAsStream(this.src);
        try {
            this.img = ImageIO.read(new File(this.src));
        }
        catch (IOException e1) {
            try {
                System.err.println(this.src);
                this.img = ImageIO.read(is);
            }
            catch (IOException e) {
                System.err.println(this.src);
                e.printStackTrace();
            }
        }
    }

    public boolean isImageLoaded() {
        return this.img != null;
    }

    public void unloadImage() {
        this.img = null;
    }

    public void setSRC(String src) {
        this.src = src;
    }

    public void setImage(BufferedImage img) {
        this.img = img;
    }
}

