/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.chunk;

import com.estrelsteel.engine2.chunk.Chunk;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.grid.PixelGrid;
import com.estrelsteel.engine2.image.Image;
import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.shape.Rotation;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.world.FrozenWorld;
import com.estrelsteel.engine2.world.World;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImageChunk
extends Chunk {
    private Image saveImg = null;
    private Rotation r = new Rotation(0.0);
    private double transX;
    private double transY;
    private double transR;

    public ImageChunk(Rectangle loc) {
        super(loc);
    }

    public Image getSavedImage() {
        return this.saveImg;
    }

    public Rotation getRotation() {
        return this.r;
    }

    public static ImageChunk convert(Chunk c) {
        ImageChunk imgC = new ImageChunk(c.getLocation());
        imgC.setObjects(c.getObjects());
        imgC.setSortable(c.isSortable());
        imgC.generateImage();
        return imgC;
    }

    public void generateImage() {
        if (this.getObjects() != null) {
            BufferedImage img = new BufferedImage((int)this.getLocation().getWidth(), (int)this.getLocation().getHeight(), 1);
            Graphics2D ctx = img.createGraphics();
            World temp = new World(new PixelGrid());
            temp.getMainCamera().setLocation(this.getLocation().getTop());
            int i = 0;
            while (i < this.getObjects().size()) {
                ctx = this.getObjects().get(i).simpleRender(ctx, temp);
                ++i;
            }
            ctx.dispose();
            this.saveImg = new Image("null");
            this.saveImg.setImage(img);
        }
    }

    @Override
    public Graphics2D render(Graphics2D ctx, FrozenWorld world) {
        if (this.saveImg == null) {
            this.generateImage();
        }
        if (this.saveImg == null) {
            super.render(ctx, world);
        } else {
            this.transX = 0.0;
            this.transY = 0.0;
            this.transR = 0.0;
            if (world instanceof World) {
                this.transX = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getX();
                this.transY = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getY();
                this.transR = ((World)world).getMainCamera().getRotation().getRadians();
            }
            AffineTransform trans = new AffineTransform();
            trans.translate(world.getGrid().moveToGrid(this.getLocation().getTop()).getX() - this.transX, world.getGrid().moveToGrid(this.getLocation().getTop()).getY() - this.transY);
            trans.scale(this.getLocation().getWidth() / (double)this.getSavedImage().getImage().getWidth(), this.getLocation().getHeight() / (double)this.getSavedImage().getImage().getHeight());
            trans.rotate(this.getRotation().getRadians() + this.transR);
            if ((this.getLocation().getX() - this.transX >= -640.0 || this.getLocation().getX() + this.getLocation().getWidth() - this.transX >= -640.0) && this.getLocation().getX() - this.transX <= 1280.0 && (this.getLocation().getY() - this.transY >= -640.0 || this.getLocation().getY() + this.getLocation().getHeight() - this.transY >= -640.0) && this.getLocation().getY() - this.transY <= 1280.0) {
                if ((this.getLocation().getX() - this.transX >= 0.0 || this.getLocation().getX() + this.getLocation().getWidth() - this.transX >= 0.0) && this.getLocation().getX() - this.transX <= 640.0 && (this.getLocation().getY() - this.transY >= 0.0 || this.getLocation().getY() + this.getLocation().getHeight() - this.transY >= 0.0) && this.getLocation().getY() - this.transY <= 640.0) {
                    if (!this.getSavedImage().isImageLoaded()) {
                        this.getSavedImage().loadImage();
                    }
                    ctx.drawImage(this.getSavedImage().getImage(), trans, null);
                }
            } else {
                int i = world.getObjects().indexOf(this);
                ((Chunk)world.getObjects().get(i)).setSaveMe(true);
            }
            Object var3_3 = null;
        }
        return ctx;
    }

    @Override
    public Graphics2D simpleRender(Graphics2D ctx, FrozenWorld world) {
        if (this.saveImg == null) {
            this.generateImage();
        }
        if (this.saveImg == null) {
            super.simpleRender(ctx, world);
        } else {
            double transX = 0.0;
            double transY = 0.0;
            if (world instanceof World) {
                transX = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getX();
                transY = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getY();
            }
            if ((this.getLocation().getX() - transX >= -640.0 || this.getLocation().getX() + this.getLocation().getWidth() - transX >= -640.0) && this.getLocation().getX() - transX <= 1280.0 && (this.getLocation().getY() - transY >= -640.0 || this.getLocation().getY() + this.getLocation().getHeight() - transY >= -640.0) && this.getLocation().getY() - transY <= 1280.0) {
                if ((this.getLocation().getX() - transX >= 0.0 || this.getLocation().getX() + this.getLocation().getWidth() - transX >= 0.0) && this.getLocation().getX() - transX <= 640.0 && (this.getLocation().getY() - transY >= 0.0 || this.getLocation().getY() + this.getLocation().getHeight() - transY >= 0.0) && this.getLocation().getY() - transY <= 640.0) {
                    if (!this.getSavedImage().isImageLoaded()) {
                        this.getSavedImage().loadImage();
                    }
                    ctx.drawImage(this.getSavedImage().getImage(), (int)(this.getLocation().getTop().getX() - transX), (int)(this.getLocation().getTop().getY() - transY), (int)this.getLocation().getWidth(), (int)this.getLocation().getHeight(), null);
                }
            } else {
                int i = world.getObjects().indexOf(this);
                ((Chunk)world.getObjects().get(i)).setSaveMe(true);
            }
        }
        return ctx;
    }

    public void setSavedImage(Image saveImg) {
        this.saveImg = saveImg;
    }

    public void setRotation(Rotation r) {
        this.r = r;
    }

    @Override
    public Renderable load(GameFile file, int line) {
        return ImageChunk.convert((Chunk)super.load(file, line));
    }
}

