/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.actor;

import com.estrelsteel.engine2.image.Animation;
import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.shape.Rotation;
import com.estrelsteel.engine2.shape.collide.Collision;
import com.estrelsteel.engine2.shape.collide.RectangleCollideArea;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.world.FrozenWorld;
import com.estrelsteel.engine2.world.World;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;

public class Actor
implements Renderable {
    private String name;
    private Rectangle loc;
    private Rotation rotation;
    private ArrayList<Animation> animations;
    private int animation;
    private boolean sortable;
    private Collision collide;
    private boolean hideOffScreen = true;

    public Actor(String name, Rectangle loc) {
        this.name = name;
        this.loc = loc;
        this.rotation = new Rotation(0.0);
        this.animations = new ArrayList();
        this.sortable = true;
        this.collide = new Collision(false, new RectangleCollideArea(loc));
    }

    public Actor(String name, Rectangle loc, Rotation rotation) {
        this.name = name;
        this.loc = loc;
        this.rotation = rotation;
        this.animations = new ArrayList();
        this.sortable = true;
        this.collide = new Collision(false, new RectangleCollideArea(loc));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Rectangle getLocation() {
        return this.loc;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public ArrayList<Animation> getAnimations() {
        return this.animations;
    }

    public Animation getRunningAnimation() {
        return this.getAnimations().get(this.animation);
    }

    public int getRunningAnimationNumber() {
        return this.animation;
    }

    public Collision getCollision() {
        return this.collide;
    }

    @Override
    public Graphics2D render(Graphics2D ctx, FrozenWorld world) {
        double x = 0.0;
        double y = 0.0;
        double r = 0.0;
        if (world instanceof World) {
            x = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getX();
            y = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getY();
            r = ((World)world).getMainCamera().getRotation().getRadians();
        }
        if (!this.getRunningAnimation().getCurrentImage().isImageLoaded()) {
            this.getRunningAnimation().getCurrentImage().loadImage();
        }
        AffineTransform trans = new AffineTransform();
        trans.translate(world.getGrid().moveToGrid(this.getLocation().getTop()).getX() - x, world.getGrid().moveToGrid(this.getLocation().getTop()).getY() - y);
        trans.scale(this.getLocation().getWidth() / (double)this.getRunningAnimation().getCurrentImage().getImage().getWidth(), this.getLocation().getHeight() / (double)this.getRunningAnimation().getCurrentImage().getImage().getHeight());
        trans.rotate(this.getRotation().getRadians() + r);
        if ((!this.hideOffScreen || (this.loc.getX() - x >= 0.0 || this.loc.getX() + this.loc.getWidth() - x >= 0.0) && this.loc.getX() - x <= 640.0) && (!this.hideOffScreen || (this.loc.getY() - y >= 0.0 || this.loc.getY() + this.loc.getHeight() - y >= 0.0) && this.loc.getY() - y <= 640.0)) {
            ctx.drawImage(this.getRunningAnimation().getCurrentImage().getImage(), trans, null);
        }
        return ctx;
    }

    @Override
    public Graphics2D simpleRender(Graphics2D ctx, FrozenWorld world) {
        double x = 0.0;
        double y = 0.0;
        if (world instanceof World) {
            x = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getX();
            y = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getY();
        }
        if (!this.getRunningAnimation().getCurrentImage().isImageLoaded()) {
            this.getRunningAnimation().getCurrentImage().loadImage();
        }
        if ((!this.hideOffScreen || (this.loc.getX() - x >= 0.0 || this.loc.getX() + this.loc.getWidth() - x >= 0.0) && this.loc.getX() - x <= 640.0) && (!this.hideOffScreen || (this.loc.getY() - y >= 0.0 || this.loc.getY() + this.loc.getHeight() - y >= 0.0) && this.loc.getY() - y <= 640.0)) {
            ctx.drawImage(this.getRunningAnimation().getCurrentImage().getImage(), (int)(this.getLocation().getTop().getX() - x), (int)(this.getLocation().getTop().getY() - y), (int)this.getLocation().getWidth(), (int)this.getLocation().getHeight(), null);
        }
        return ctx;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    public boolean doHideOffScreen() {
        return this.hideOffScreen;
    }

    public boolean equals(Object other) {
        return this.name.equals(((Actor)other).getName());
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setLocation(Rectangle loc) {
        this.loc = loc;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public void setAnimations(ArrayList<Animation> animations) {
        this.animations = animations;
    }

    public void setRunningAnimationNumber(int animation) {
        this.animation = animation;
    }

    @Override
    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void setCollision(Collision collide) {
        this.collide = collide;
    }

    public Actor setHideOffScreen(boolean hide) {
        this.hideOffScreen = hide;
        return this;
    }
}

