/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld37.world;

import com.estrelsteel.engine2.chunk.ImageChunk;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.tile.Tile;
import com.estrelsteel.engine2.tile.TileType;
import com.estrelsteel.engine2.world.FrozenWorld;
import com.estrelsteel.ld37.objects.Entrance;
import com.estrelsteel.ld37.objects.Hole;
import com.estrelsteel.ld37.objects.furniture.Furniture;
import com.estrelsteel.ld37.objects.furniture.FurnitureType;
import com.estrelsteel.ld37.world.RoomWorld;
import java.util.ArrayList;

public class Level
implements Saveable {
    private FrozenWorld w;
    private double length;
    private int zombies;

    public Level(FrozenWorld w) {
        this.w = w;
    }

    public double getLevelLength() {
        return this.length;
    }

    public int getZombies() {
        return this.zombies;
    }

    public void setLevelLength(double length) {
        this.length = length;
    }

    public void setZombies(int zombies) {
        this.zombies = zombies;
    }

    @Override
    public String getIdentifier() {
        return "LVL";
    }

    @Override
    public FrozenWorld load(GameFile file, int line) {
        ArrayList<Renderable> tiles = new ArrayList<Renderable>();
        double sx = 0.0;
        double sy = 0.0;
        double width = 64.0;
        double height = 64.0;
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        String[] args = file.getLines().get(line).split(" ");
        if (args[0].equalsIgnoreCase(this.getIdentifier())) {
            sx = Double.parseDouble(args[1]);
            sy = Double.parseDouble(args[2]);
            width = Double.parseDouble(args[3]);
            height = Double.parseDouble(args[4]);
            this.length = Double.parseDouble(args[5]);
            this.zombies = Integer.parseInt(args[6]);
            int i = 0;
            i = line + 1;
            while (i < file.getLines().size()) {
                args = file.getLines().get(i).split(" ");
                if (args[0].equalsIgnoreCase("###")) break;
                int j = 0;
                while (j < args.length) {
                    if (Integer.parseInt(args[j]) >= 0) {
                        tiles.add(new Tile(TileType.types.get(Integer.parseInt(args[j])), QuickRectangle.location(sx + width * (double)j, sy + height * (double)(i - line - 1), width, height)).setHideOffScreen(false));
                        if (width * (double)j > maxWidth) {
                            maxWidth = width * (double)j;
                        }
                        if (height * (double)(i - line - 1) > maxHeight) {
                            maxHeight = height * (double)(i - line - 1);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            ImageChunk ic = new ImageChunk(QuickRectangle.location(sx, sy, maxWidth + width, maxHeight + height));
            ic.setObjects(tiles);
            ic.generateImage();
            ArrayList<Entrance> other = new ArrayList<Entrance>();
            this.w.getObjects().add(ic);
            ++i;
            while (i < file.getLines().size()) {
                args = file.getLines().get(i).split(" ");
                if (args[0].equalsIgnoreCase("###")) break;
                if (args[0].equalsIgnoreCase("ENT")) {
                    if (this.w instanceof RoomWorld) {
                        ((RoomWorld)this.w).getEntrances().add(new Entrance(Double.parseDouble(args[1]), QuickRectangle.location(Double.parseDouble(args[2]), Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5])), QuickRectangle.location(Double.parseDouble(args[6]), Double.parseDouble(args[7]), Double.parseDouble(args[8]), Double.parseDouble(args[9])), Boolean.parseBoolean(args[10])));
                    } else {
                        other.add(new Entrance(Double.parseDouble(args[1]), QuickRectangle.location(Double.parseDouble(args[2]), Double.parseDouble(args[3]), Double.parseDouble(args[4]), Double.parseDouble(args[5])), QuickRectangle.location(Double.parseDouble(args[6]), Double.parseDouble(args[7]), Double.parseDouble(args[8]), Double.parseDouble(args[9])), Boolean.parseBoolean(args[10])));
                    }
                } else if (args[0].equalsIgnoreCase("FUR")) {
                    this.w.getObjects().add(new Furniture(QuickRectangle.location(Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]), Double.parseDouble(args[4])), FurnitureType.values()[Integer.parseInt(args[5])]));
                } else if (args[0].equalsIgnoreCase("HOL")) {
                    this.w.getObjects().add(new Hole(QuickRectangle.location(Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]), Double.parseDouble(args[4])), Integer.parseInt(args[5])));
                }
                ++i;
            }
            return this.w;
        }
        return this.w;
    }

    @Override
    public GameFile save(GameFile file) {
        return null;
    }
}

