/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld37.objects;

import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.world.FrozenWorld;
import com.estrelsteel.engine2.world.World;
import com.estrelsteel.ld37.objects.furniture.Furniture;
import java.awt.Color;
import java.awt.Graphics2D;

public class Entrance
implements Renderable {
    private double hp;
    private double maxHP;
    private Rectangle loc;
    private Rectangle hpBar;
    private Rectangle repair;
    private Furniture f;
    private boolean high;

    public Entrance(double maxHP, Rectangle loc, Rectangle repair, boolean high) {
        this.maxHP = maxHP;
        this.hp = maxHP;
        this.loc = loc;
        this.hpBar = loc;
        this.repair = repair;
        this.f = null;
        this.high = high;
    }

    public double getHealth() {
        return this.hp;
    }

    public double getMaxHealth() {
        return this.maxHP;
    }

    @Override
    public Rectangle getLocation() {
        return this.loc;
    }

    public Rectangle getHealthBar() {
        return this.hpBar;
    }

    public Rectangle getRepairZone() {
        return this.repair;
    }

    public Furniture getFurniture() {
        return this.f;
    }

    public boolean isHigh() {
        return this.high;
    }

    public void setHealth(double hp) {
        this.hp = hp;
    }

    public void setMaxHealth(double maxHP) {
        this.maxHP = maxHP;
    }

    @Override
    public void setLocation(Rectangle loc) {
        this.loc = loc;
    }

    public void setHealthBar(Rectangle hpBar) {
        this.hpBar = hpBar;
    }

    public void setRepairZone(Rectangle repair) {
        this.repair = repair;
    }

    public void setFurniture(Furniture f) {
        this.f = f;
    }

    public void setHigh(boolean high) {
        this.high = high;
    }

    private void updateHealthBar() {
        if (this.hp > this.maxHP) {
            this.hp = this.maxHP;
        }
        if (this.hp < 0.0) {
            this.hp = 0.0;
        }
        this.hpBar = QuickRectangle.location(this.loc.getX(), this.loc.getY(), this.loc.getWidth() * (this.hp / this.maxHP), this.loc.getHeight());
    }

    @Override
    public Graphics2D render(Graphics2D ctx, FrozenWorld world) {
        return this.simpleRender(ctx, world);
    }

    @Override
    public Graphics2D simpleRender(Graphics2D ctx, FrozenWorld world) {
        double x = 0.0;
        double y = 0.0;
        if (world instanceof World) {
            x = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getX();
            y = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getY();
        }
        if ((this.loc.getX() - x >= 0.0 || this.loc.getX() + this.loc.getWidth() - x >= 0.0) && this.loc.getX() - x <= 640.0 && (this.loc.getY() - y >= 0.0 || this.loc.getY() + this.loc.getHeight() - y >= 0.0) && this.loc.getY() - y <= 640.0) {
            this.updateHealthBar();
            if (this.f != null) {
                ctx.setColor(Color.YELLOW);
                ctx.fillRect((int)(this.hpBar.getX() - x), (int)(this.hpBar.getY() - y + this.hpBar.getHeight() + 4.0), (int)(this.loc.getWidth() * (this.f.getHealth() / this.f.getMaxHealth())), 12);
            }
            ctx.setColor(Color.BLACK);
            ctx.fillRect((int)(this.loc.getX() - x - 2.0), (int)(this.loc.getY() - y - 2.0), (int)this.loc.getWidth() + 4, (int)this.loc.getHeight() + 4);
            ctx.setColor(Color.RED);
            ctx.fillRect((int)(this.loc.getX() - x), (int)(this.loc.getY() - y), (int)this.loc.getWidth(), (int)this.loc.getHeight());
            ctx.setColor(Color.GREEN);
            ctx.fillRect((int)(this.hpBar.getX() - x), (int)(this.hpBar.getY() - y), (int)this.hpBar.getWidth(), (int)this.hpBar.getHeight());
        }
        return ctx;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public void setSortable(boolean sortable) {
    }
}

