/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld37;

import com.estrelsteel.engine2.Engine2;
import com.estrelsteel.engine2.Launcher;
import com.estrelsteel.engine2.actor.Camera;
import com.estrelsteel.engine2.events.listener.RenderListener;
import com.estrelsteel.engine2.events.listener.StartListener;
import com.estrelsteel.engine2.events.listener.StopListener;
import com.estrelsteel.engine2.events.listener.TickListener;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.grid.PixelGrid;
import com.estrelsteel.engine2.image.Image;
import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.point.Point2;
import com.estrelsteel.engine2.shape.collide.Collision;
import com.estrelsteel.engine2.shape.collide.PerspectiveRectangleArea;
import com.estrelsteel.engine2.shape.collide.RectangleCollideArea;
import com.estrelsteel.engine2.shape.rectangle.AbstractedRectangle;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.tile.TileType;
import com.estrelsteel.engine2.window.WindowSettings;
import com.estrelsteel.ld37.handler.GameState;
import com.estrelsteel.ld37.handler.KeyHandler;
import com.estrelsteel.ld37.handler.MouseHandler;
import com.estrelsteel.ld37.objects.Entrance;
import com.estrelsteel.ld37.objects.Hole;
import com.estrelsteel.ld37.objects.Player;
import com.estrelsteel.ld37.objects.Snowball;
import com.estrelsteel.ld37.objects.furniture.Furniture;
import com.estrelsteel.ld37.world.Level;
import com.estrelsteel.ld37.world.RoomWorld;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;

public class LD37
implements StartListener,
StopListener,
TickListener,
RenderListener {
    private Launcher l = new Launcher();
    private RoomWorld w;
    private Player p;
    public int lvlNum;
    public GameState gs;
    private GameFile msg;
    public Furniture moving;
    private KeyHandler key;
    private MouseHandler mouse;
    private Image title;
    private Rectangle pLoc;
    private Rectangle npLoc;
    private Entrance e;
    private RectangleCollideArea a;
    private AbstractedRectangle click;
    private Renderable r;
    private Renderable r2;
    private Rectangle sLoc;
    public boolean endless;
    private int round;
    private int highscore;
    public boolean complete;
    private GameFile settings;
    private double shortErr;

    public static void main(String[] args) {
        new LD37();
    }

    public LD37() {
        Rectangle size = System.getProperty("os.name").startsWith("Windows") ? QuickRectangle.location(0.0, 0.0, 630.0, 630.0) : QuickRectangle.location(0.0, 0.0, 640.0, 640.0);
        this.l.getEngine().setWindowSettings(new WindowSettings(size, "Snowmen Defense - EstrelSteel", "v1.0a", 0));
        this.key = new KeyHandler(this);
        this.mouse = new MouseHandler();
        this.lvlNum = 0;
        this.complete = false;
        this.l.getEngine().START_EVENT.addListener(this);
        this.l.getEngine().STOP_EVENT.addListener(this);
        this.l.getEngine().RENDER_EVENT.addListener(this);
        this.l.getEngine().TICK_EVENT.addListener(this);
        this.l.getEngine().addKeyListener(this.key);
        this.l.getEngine().addMouseListener(this.mouse);
        this.l.getEngine().addMouseMotionListener(this.mouse);
        this.l.getEngine();
        Engine2.development = true;
        this.l.getEngine();
        Engine2.devPath = GameFile.getCurrentPath();
        this.l.boot();
    }

    @Override
    public void start() {
        TileType tt = new TileType(-1, "null");
        tt.load(new GameFile(String.valueOf(Engine2.devPath) + "/res/tiles.txt"), 0);
        this.endless = false;
        this.round = 0;
        this.title = new Image(String.valueOf(Engine2.devPath) + "/res/img/title.png");
        this.settings = new GameFile(String.valueOf(Engine2.devPath) + "/res/settings.txt");
        try {
            this.settings.setLines(this.settings.readFile());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.settings.getLines().size() > 0) {
            this.complete = Boolean.parseBoolean(this.settings.getLines().get(0));
            this.highscore = Integer.parseInt(this.settings.getLines().get(1));
        }
        this.loadLevel(this.lvlNum);
    }

    public void loadLevel(int lvlNum) {
        this.w = new RoomWorld(new PixelGrid());
        this.w = new RoomWorld(new PixelGrid());
        this.w.getCameras().add(new Camera("main", new Point2(0.0, 0.0, new PixelGrid())));
        this.p = new Player("player", QuickRectangle.location(640.0, 640.0, 64.0, 64.0));
        this.p.setCollision(new Collision(true, new PerspectiveRectangleArea(QuickRectangle.location(0.0, 0.0, 64.0, 64.0))));
        if (lvlNum == 10) {
            this.complete = true;
            lvlNum = 10;
            this.endless = true;
            ++this.round;
        } else if (lvlNum > 10 && this.endless) {
            lvlNum = 11;
            ++this.round;
        }
        Level lvl = new Level(this.w);
        GameFile lvlF = new GameFile(String.valueOf(Engine2.devPath) + "/res/lvl/lvl" + lvlNum + ".txt");
        try {
            lvlF.setLines(lvlF.readFile());
        }
        catch (IOException e) {
            this.loadLevel(-1);
            return;
        }
        this.msg = new GameFile(String.valueOf(Engine2.devPath) + "/res/lvl/lvl" + lvlNum + "-text.txt");
        try {
            this.msg.setLines(this.msg.readFile());
        }
        catch (IOException e) {
            System.err.println("ERR: No message text!");
        }
        this.w = (RoomWorld)lvl.load(lvlF, 0);
        this.w.getObjects().add(this.p);
        this.w.setStartTime(System.currentTimeMillis());
        this.w.setLevelLength(lvl.getLevelLength());
        this.w.setZombies(lvl.getZombies());
        this.w.setZombies(this.w.getZombies() + 10 * this.round);
        this.shortErr = 0.0;
        this.moving = null;
        this.gs = GameState.MESSAGE;
    }

    @Override
    public void stop() {
        if (this.settings.getLines().size() > 0) {
            this.settings.getLines().set(0, String.valueOf(this.complete));
            if (this.round > Integer.parseInt(this.settings.getLines().get(1))) {
                this.settings.getLines().set(1, String.valueOf(this.round));
            }
        }
        try {
            this.settings.saveFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Graphics2D render(Graphics2D ctx) {
        if (this.lvlNum == 0) {
            if (!this.title.isImageLoaded()) {
                this.title.loadImage();
            }
            ctx.drawImage(this.title.getImage(), 0, 0, 640, 640, null);
            if (!this.complete) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(0, 560, 640, 80);
            }
            return ctx;
        }
        this.w.sortObjects();
        this.w.renderWorld(ctx);
        if ((double)System.currentTimeMillis() - this.shortErr <= 3000.0) {
            ctx.setColor(Color.WHITE);
            ctx.fillRect(220, 240, 200, 45);
            ctx.setFont(new Font("Menlo", 1, 12));
            ctx.setColor(Color.BLACK);
            ctx.drawString("That object is too short", 235, 260);
            ctx.drawString("to help defend there.", 250, 275);
        }
        if (this.w.getLevelLength() - ((double)System.currentTimeMillis() - this.w.getStartTime()) <= 0.0 && this.gs == GameState.RUNNING) {
            this.gs = GameState.WIN;
        }
        if (this.gs == GameState.WIN) {
            if (!this.endless) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(85, 200, 475, 90);
                ctx.setFont(new Font("Menlo", 1, 48));
                ctx.setColor(Color.BLACK);
                ctx.drawString("Level Complete!", 105, 240);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("Press [enter] to continue...", 180, 280);
            } else {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(85, 200, 475, 90);
                ctx.setFont(new Font("Menlo", 1, 48));
                ctx.setColor(Color.BLACK);
                ctx.drawString("Round Complete!", 107, 240);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("Press [enter] to continue...", 180, 280);
            }
        } else if (this.gs == GameState.LOSE) {
            if (!this.endless) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(125, 200, 395, 90);
                ctx.setFont(new Font("Menlo", 1, 48));
                ctx.setColor(Color.BLACK);
                ctx.drawString("Level Failed!", 135, 240);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("Press [enter] to restart...", 185, 280);
            } else {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(125, 200, 395, 90);
                ctx.setFont(new Font("Menlo", 1, 48));
                ctx.setColor(Color.BLACK);
                ctx.drawString("Round Failed!", 135, 240);
                ctx.setFont(new Font("Menlo", 1, 16));
                ctx.drawString("Completed Rounds: " + this.round, 225, 260);
                ctx.drawString("Press [enter] to continue to credits.", 136, 280);
            }
        } else if (this.gs == GameState.RUNNING) {
            ctx.setColor(Color.WHITE);
            ctx.fillRect(20, 20, 150, 40);
            ctx.setColor(Color.BLACK);
            ctx.drawString("Time Remaining: " + (int)((this.w.getLevelLength() - ((double)System.currentTimeMillis() - this.w.getStartTime())) / 1000.0), 30, 45);
            if (this.endless) {
                ctx.setColor(Color.WHITE);
                ctx.fillRect(540, 20, 80, 40);
                ctx.fillRect(270, 20, 100, 40);
                ctx.setColor(Color.BLACK);
                ctx.drawString("Round: " + this.round, 550, 45);
                ctx.drawString("Highscore: " + this.highscore, 280, 45);
            }
        } else if (this.gs == GameState.MESSAGE) {
            ctx.setColor(Color.WHITE);
            ctx.fillRect(16, 8, 608, 20 * this.msg.getLines().size() + 16);
            ctx.setColor(Color.BLACK);
            ctx.setFont(new Font("Menlo", 1, 16));
            int i = 0;
            while (i < this.msg.getLines().size()) {
                ctx.drawString(this.msg.getLines().get(i), 20, 20 * (i + 1) + 8);
                ++i;
            }
            this.w.setStartTime(System.currentTimeMillis());
        }
        if (this.moving != null) {
            this.moving.setLocation(QuickRectangle.location((double)this.mouse.x + this.w.getMainCamera().getLocation().getX() - this.moving.getLocation().getWidth() / 2.0, (double)this.mouse.y + this.w.getMainCamera().getLocation().getY() - this.moving.getLocation().getHeight() / 2.0, this.moving.getLocation().getWidth(), this.moving.getLocation().getHeight()));
            this.moving.render(ctx, this.w);
        }
        return ctx;
    }

    @Override
    public void tick() {
        if (this.gs == GameState.RUNNING) {
            this.pLoc = this.p.getLocation();
            if (this.key.left) {
                this.npLoc = QuickRectangle.location(this.pLoc.getX() - this.p.getWalkspeed(), this.pLoc.getY(), this.pLoc.getWidth(), this.pLoc.getHeight());
                this.p.setRunningAnimationNumber(2);
                if (this.w.checkCollide(new PerspectiveRectangleArea(this.npLoc), this.p) == null) {
                    this.p.setLocation(this.npLoc);
                    this.pLoc = this.p.getLocation();
                }
            }
            if (this.key.right) {
                this.npLoc = QuickRectangle.location(this.pLoc.getX() + this.p.getWalkspeed(), this.pLoc.getY(), this.pLoc.getWidth(), this.pLoc.getHeight());
                this.p.setRunningAnimationNumber(3);
                if (this.w.checkCollide(new PerspectiveRectangleArea(this.npLoc), this.p) == null) {
                    this.p.setLocation(this.npLoc);
                    this.pLoc = this.p.getLocation();
                }
            }
            if (this.key.up) {
                this.npLoc = QuickRectangle.location(this.pLoc.getX(), this.pLoc.getY() - this.p.getWalkspeed(), this.pLoc.getWidth(), this.pLoc.getHeight());
                this.p.setRunningAnimationNumber(1);
                if (this.w.checkCollide(new PerspectiveRectangleArea(this.npLoc), this.p) == null) {
                    this.p.setLocation(this.npLoc);
                    this.pLoc = this.p.getLocation();
                }
            }
            if (this.key.down) {
                this.npLoc = QuickRectangle.location(this.pLoc.getX(), this.pLoc.getY() + this.p.getWalkspeed(), this.pLoc.getWidth(), this.pLoc.getHeight());
                this.p.setRunningAnimationNumber(0);
                if (this.w.checkCollide(new PerspectiveRectangleArea(this.npLoc), this.p) == null) {
                    this.p.setLocation(this.npLoc);
                    this.pLoc = this.p.getLocation();
                }
            }
            if (this.key.repair) {
                this.e = this.w.collideWithEntrance(this.p.getLocation());
                if (this.e != null) {
                    this.e.setHealth(this.e.getHealth() + this.p.getRepairSpeed());
                }
            }
            if (this.mouse.click && this.moving == null) {
                this.click = QuickRectangle.location((double)(this.mouse.x - 5) + this.w.getMainCamera().getLocation().getX(), (double)(this.mouse.y - 5) + this.w.getMainCamera().getLocation().getY(), 10.0, 10.0);
                int i = 0;
                while (i < this.w.getObjects().size()) {
                    this.r = this.w.getObjects().get(i);
                    if (this.r instanceof Furniture) {
                        this.a = new RectangleCollideArea(this.r.getLocation());
                        if (((Furniture)this.r).getEntrance() == null && this.a.checkCollision(this.click)) {
                            this.moving = (Furniture)this.w.getObjects().get(i);
                            this.w.getObjects().remove(i);
                            this.mouse.click = false;
                            break;
                        }
                    }
                    ++i;
                }
            } else if (this.mouse.click && this.moving != null) {
                this.click = QuickRectangle.location((double)(this.mouse.x - 5) + this.w.getMainCamera().getLocation().getX(), (double)(this.mouse.y - 5) + this.w.getMainCamera().getLocation().getY(), 10.0, 10.0);
                boolean found = false;
                int i = 0;
                while (i < this.w.getEntrances().size()) {
                    this.e = this.w.getEntrances().get(i);
                    this.a = new RectangleCollideArea(this.e.getRepairZone());
                    if (this.a.checkCollision(this.click) && this.e.getFurniture() == null) {
                        if (this.e.isHigh() && !this.moving.getType().isTall()) {
                            this.shortErr = System.currentTimeMillis();
                        } else {
                            this.moving.setLocation(QuickRectangle.location(this.e.getRepairZone().getX(), this.e.getRepairZone().getY() + this.e.getRepairZone().getHeight() - this.moving.getLocation().getHeight() - 32.0, this.moving.getLocation().getWidth(), this.moving.getLocation().getHeight()));
                            this.moving.setEntrance(this.e);
                            this.e.setFurniture(this.moving);
                            this.w.getObjects().add(this.moving);
                            this.moving = null;
                            this.mouse.click = false;
                            found = true;
                        }
                        break;
                    }
                    ++i;
                }
            }
            this.w.runZombies();
            for (Entrance e1 : this.w.getEntrances()) {
                if (!(e1.getHealth() <= 0.0)) continue;
                this.gs = GameState.LOSE;
            }
            int i = 0;
            while (i < this.w.getObjects().size()) {
                this.r = this.w.getObjects().get(i);
                if (this.r instanceof Furniture) {
                    if (((Furniture)this.r).getEntrance() != null && ((Furniture)this.r).getEntrance().getFurniture() == null) {
                        this.w.getObjects().remove(i);
                        --i;
                    }
                } else if (this.r instanceof Hole) {
                    if (System.currentTimeMillis() - ((Hole)this.r).getLastSpawn() >= (long)((Hole)this.r).getSpawnSpeed()) {
                        ((Hole)this.r).setLastSpawn(System.currentTimeMillis());
                        this.w.getObjects().add(new Snowball(QuickRectangle.location(this.r.getLocation().getX() + 16.0, this.r.getLocation().getY() + 16.0, 32.0, 32.0)));
                    }
                } else if (this.r instanceof Snowball) {
                    if (((Snowball)this.r).doDestroy()) {
                        this.w.getObjects().remove(i);
                        --i;
                    } else {
                        this.sLoc = QuickRectangle.location(this.r.getLocation().getX(), ((Snowball)this.r).getSpeed() + this.r.getLocation().getY(), this.r.getLocation().getWidth(), this.r.getLocation().getHeight());
                        this.r2 = this.w.checkCollide(new RectangleCollideArea(this.sLoc), this.r);
                        if (this.r2 instanceof Player) {
                            this.gs = GameState.LOSE;
                        }
                        if (System.currentTimeMillis() - ((Snowball)this.r).getSpawnTime() >= 1000L) {
                            if (this.r2 == null) {
                                this.r.setLocation(this.sLoc);
                            } else {
                                this.w.getObjects().remove(i);
                                --i;
                            }
                        } else {
                            this.r.setLocation(this.sLoc);
                        }
                    }
                }
                ++i;
            }
        }
        this.w.getMainCamera().setLocation(new Point2(this.p.getLocation().getX() - 288.0, this.p.getLocation().getY() - 288.0, new PixelGrid()));
        this.p.getRunningAnimation().run();
    }
}

