/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.tile;

import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.image.Animation;
import java.io.IOException;
import java.util.ArrayList;

public class TileType
implements Saveable {
    public static ArrayList<TileType> types;
    private int id;
    private String name;
    private boolean collide;
    private Animation animation;

    public TileType(int id, String name) {
        this.id = id;
        this.name = name;
        this.collide = false;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public boolean doesCollide() {
        return this.collide;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCollide(boolean collide) {
        this.collide = collide;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Override
    public String getIdentifier() {
        return "TTY";
    }

    @Override
    public ArrayList<TileType> load(GameFile file, int line) {
        try {
            file.updateLines();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (types == null) {
            types = new ArrayList();
        }
        int i = line;
        while (i < file.getLines().size()) {
            String[] args = file.getLines().get(i).split(" ");
            if (args[0].trim().equalsIgnoreCase(this.getIdentifier())) {
                TileType type = new TileType(-1, this.name);
                type.setID(Integer.parseInt(args[1].trim()));
                type.setName(args[2].trim());
                type.setCollide(Boolean.parseBoolean(args[3].trim()));
                type.setAnimation(Animation.build(file, i + 1, this.name, 0));
                types.add(type);
            }
            ++i;
        }
        return types;
    }

    @Override
    public GameFile save(GameFile file) {
        return file;
    }
}

