/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.shape.collide;

import com.estrelsteel.engine2.point.AbstractedPoint;
import com.estrelsteel.engine2.shape.collide.CollideArea;
import com.estrelsteel.engine2.shape.rectangle.AbstractedRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;

public class PerspectiveRectangleArea
implements CollideArea {
    private Rectangle rect;

    public PerspectiveRectangleArea(Rectangle rect) {
        this.rect = rect;
    }

    public Rectangle getRectangle() {
        return this.rect;
    }

    @Override
    public boolean checkCollision(AbstractedPoint point) {
        return this.rect.getTop().getX() <= point.getX() && this.rect.getTop().getX() + this.rect.getWidth() >= point.getX() && this.rect.getTop().getY() + this.rect.getHeight() * 0.8 <= point.getY() && this.rect.getTop().getY() + this.rect.getHeight() >= point.getY();
    }

    @Override
    public boolean checkCollision(AbstractedRectangle collide) {
        return this.rect.getX() + this.rect.getWidth() >= collide.getX() && (this.rect.getX() <= collide.getX() || this.rect.getX() <= collide.getX() + collide.getWidth()) && this.rect.getY() + this.rect.getHeight() >= collide.getY() && (this.rect.getY() + this.rect.getHeight() * 0.8 <= collide.getY() || this.rect.getY() + this.rect.getHeight() * 0.8 <= collide.getY() + collide.getHeight());
    }

    public void setRectangle(Rectangle rect) {
        this.rect = rect;
    }
}

