/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.setting;

import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.setting.BaseSetting;
import java.util.ArrayList;
import java.util.Iterator;

public class Settings<BaseSetting>
implements Iterator<BaseSetting>,
Saveable {
    private String name;
    private String path;
    private ArrayList<BaseSetting> settings;

    public Settings(String name, String path) {
        this.name = name;
        this.path = path;
        this.settings = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public boolean hasNext() {
        return this.settings.iterator().hasNext();
    }

    @Override
    public BaseSetting next() {
        return this.settings.iterator().next();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getIdentifier() {
        return "SET";
    }

    @Override
    public Settings<BaseSetting> load(GameFile file, int line) {
        if (file.getLines().get(line).equalsIgnoreCase(this.getIdentifier())) {
            if (BaseSetting.types == null) {
                BaseSetting.loadTypes();
            }
            ++line;
            while (line < file.getLines().size()) {
                for (BaseSetting setting : BaseSetting.types) {
                    if (!setting.getIdentifier().equalsIgnoreCase(file.getLines().get(line).substring(0, 3))) continue;
                    this.settings.add(setting.load(file, line));
                }
                ++line;
            }
        }
        return this;
    }

    @Override
    public GameFile save(GameFile file) {
        return null;
    }
}

