/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.image;

import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.image.ConfinedImage;
import com.estrelsteel.engine2.image.Image;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import java.util.ArrayList;

public class Animation {
    private String name;
    private int id;
    private ArrayList<Image> frames;
    private int frame;
    private int wait;
    private int maxWait;
    private boolean running;

    public Animation(String name, int id) {
        this.name = name;
        this.id = id;
        this.frames = new ArrayList();
        this.frame = 0;
        this.wait = 0;
        this.maxWait = 1;
        this.running = true;
    }

    public static Animation build(GameFile file, int line, String name, int id) {
        Animation a = new Animation(name, id);
        int i = line;
        while (i < file.getLines().size()) {
            String[] args = file.getLines().get(line).split(" ");
            if (args[0].trim().equalsIgnoreCase("+cimg")) {
                a.getFrames().add(new ConfinedImage(String.valueOf(GameFile.getDataPath()) + args[1].trim(), QuickRectangle.location(Double.parseDouble(args[2].trim()) * 16.0, Double.parseDouble(args[3].trim()) * 16.0, Double.parseDouble(args[4].trim()), Double.parseDouble(args[5].trim()))));
            } else {
                if (!args[0].trim().equalsIgnoreCase("+img")) break;
                a.getFrames().add(new Image(String.valueOf(GameFile.getDataPath()) + args[1].trim()));
            }
            ++i;
        }
        return a;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public ArrayList<Image> getFrames() {
        return this.frames;
    }

    public int getCurrentFrame() {
        return this.frame;
    }

    public int getCurrentWaitTime() {
        return this.wait;
    }

    public int getMaxWaitTime() {
        return this.maxWait;
    }

    public Image getCurrentImage() {
        return this.frames.get(this.frame);
    }

    public Image run() {
        if (this.running) {
            ++this.wait;
            if (this.wait >= this.maxWait) {
                this.wait = 0;
                ++this.frame;
            }
            if (this.frame >= this.frames.size()) {
                this.frame = 0;
            }
        }
        return this.frames.get(this.frame);
    }

    public boolean equals(Object other) {
        return this.frames.equals(((Animation)other).getFrames()) && this.name.equals(((Animation)other).getName()) && this.id == ((Animation)other).getID() && this.maxWait == ((Animation)other).getMaxWaitTime();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void setFrames(ArrayList<Image> frames) {
        this.frames = frames;
    }

    public void setCurrentFrame(int frame) {
        this.frame = frame;
    }

    public void setCurrentWaitTime(int wait) {
        this.wait = wait;
    }

    public void setMaxWaitTime(int maxWait) {
        this.maxWait = maxWait;
    }
}

