/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.chunk;

import com.estrelsteel.engine2.chunk.Chunk;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.tile.Tile;
import com.estrelsteel.engine2.tile.TileType;
import java.util.ArrayList;

public class TileChunkSaver
implements Saveable {
    private Chunk c;
    private ArrayList<Renderable> helper;

    public TileChunkSaver(Chunk c) {
        this.c = c;
        this.helper = new ArrayList();
    }

    public Chunk getChunk() {
        return this.c;
    }

    @Override
    public String getIdentifier() {
        return "TCS";
    }

    @Override
    public Renderable load(GameFile file, int line) {
        return this.load(file.getLines().get(line));
    }

    public Renderable load(String line) {
        Chunk c = new Chunk(QuickRectangle.location(0.0, 0.0, 0.0, 0.0));
        String[] args = line.split("~");
        if (args[0].trim().equalsIgnoreCase(this.getIdentifier())) {
            c.setLocation(QuickRectangle.location(Double.parseDouble(args[1].trim()), Double.parseDouble(args[2].trim()), Double.parseDouble(args[3].trim()), Double.parseDouble(args[4].trim())));
            c.setAltered(Boolean.parseBoolean(args[5].trim()));
            c.setSortable(false);
            int x = 0;
            int y = 0;
            int i = 6;
            while (i < args.length) {
                c.getObjects().add(new Tile(TileType.types.get(Integer.parseInt(args[i].trim())), QuickRectangle.location((double)(x * 64) + c.getLocation().getX(), (double)(y * 64) + c.getLocation().getY(), 64.0, 64.0)));
                ++x;
                if ((double)x >= c.getLocation().getWidth() / 64.0) {
                    x = 0;
                    ++y;
                }
                ++i;
            }
        }
        return c;
    }

    @Override
    public GameFile save(GameFile file) {
        if (file.getLines().size() > 0) {
            file.getLines().set(0, this.generateSaveLine());
        } else {
            file.getLines().add(0, this.generateSaveLine());
        }
        return file;
    }

    public String generateSaveLine() {
        String line = String.valueOf(this.getIdentifier()) + "~" + this.c.getLocation().getX() + "~" + this.c.getLocation().getY() + "~" + this.c.getLocation().getWidth() + "~" + this.c.getLocation().getHeight();
        line = String.valueOf(line) + "~" + this.c.isAltered();
        int i = 0;
        while (i < this.c.getObjects().size()) {
            if (this.c.getObjects().get(i) instanceof Tile) {
                line = String.valueOf(line) + "~" + ((Tile)this.c.getObjects().get(i)).getType().getID();
            } else {
                System.err.println("ERROR: Tile attempted to be saved in tile only chunk saver!!!!");
            }
            ++i;
        }
        return line;
    }

    public void sortObjects() {
        if (this.checkSort()) {
            this.helper = new ArrayList();
            int i = 0;
            while (i < this.c.getObjects().size()) {
                this.helper.add(this.c.getObjects().get(i));
                ++i;
            }
            this.mergeSort(0, this.c.getObjects().size() - 1);
        }
    }

    public boolean checkSort() {
        int l = 0;
        int i = 1;
        while (i < this.c.getObjects().size()) {
            if (this.determineValue(this.helper.get(i)) <= this.determineValue(this.helper.get(l))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void mergeSort(int low, int high) {
        if (low < high) {
            int middle = low + (high - low) / 2;
            this.mergeSort(low, middle);
            this.mergeSort(middle + 1, high);
            this.merge(low, middle, high);
        }
    }

    private void merge(int low, int middle, int high) {
        int i = low;
        while (i <= high) {
            this.helper.set(i, this.c.getObjects().get(i));
            ++i;
        }
        i = low;
        int j = middle + 1;
        int k = low;
        while (i <= middle && j <= high) {
            if (this.determineValue(this.helper.get(i)) <= this.determineValue(this.helper.get(j))) {
                this.c.getObjects().set(k, this.helper.get(i));
                ++i;
            } else {
                this.c.getObjects().set(k, this.helper.get(j));
                ++j;
            }
            ++k;
        }
        while (i <= middle) {
            this.c.getObjects().set(k, this.helper.get(i));
            ++k;
            ++i;
        }
    }

    private double determineValue(Renderable r) {
        return (r.getLocation().getX() - this.c.getLocation().getX()) / 64.0 + (r.getLocation().getY() - this.c.getLocation().getY()) / 64.0 * ((this.c.getLocation().getWidth() + 10.0) / 64.0);
    }

    public void setChunk(Chunk c) {
        this.c = c;
    }
}

