/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.chunk;

import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.file.Saveable;
import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.tile.Tile;
import com.estrelsteel.engine2.tile.TileType;
import com.estrelsteel.engine2.world.FrozenWorld;
import com.estrelsteel.engine2.world.World;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Chunk
implements Renderable,
Saveable {
    private Rectangle loc;
    private boolean sortable;
    private ArrayList<Renderable> objects;
    private double transX;
    private double transY;
    private boolean altered;
    private boolean structured;
    private boolean saveMe;

    public Chunk(Rectangle loc) {
        this.loc = loc;
        this.sortable = false;
        this.objects = new ArrayList();
        this.altered = false;
        this.structured = false;
        this.saveMe = false;
    }

    @Override
    public Rectangle getLocation() {
        return this.loc;
    }

    public ArrayList<Renderable> getObjects() {
        return this.objects;
    }

    @Override
    public Graphics2D render(Graphics2D ctx, FrozenWorld world) {
        this.transX = 0.0;
        this.transY = 0.0;
        if (world instanceof World) {
            this.transX = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getX();
            this.transY = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getY();
        }
        if ((this.transX + this.loc.getX() >= 0.0 || this.transX + this.loc.getX() + this.loc.getWidth() >= 0.0) && this.transX + this.loc.getX() <= 640.0 && (this.transY + this.loc.getY() >= 0.0 || this.transY + this.loc.getY() + this.loc.getHeight() >= 0.0) && this.transY + this.loc.getY() <= 640.0) {
            int i = 0;
            while (i < this.objects.size()) {
                this.objects.get(i).render(ctx, world);
                ++i;
            }
        }
        return ctx;
    }

    @Override
    public Graphics2D simpleRender(Graphics2D ctx, FrozenWorld world) {
        double transX = 0.0;
        double transY = 0.0;
        if (world instanceof World) {
            transX = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getX();
            transY = world.getGrid().moveToGrid(((World)world).getMainCamera().getLocation()).getY();
        }
        if ((this.loc.getX() - transX >= 0.0 || this.loc.getX() + this.loc.getWidth() - transX >= 0.0) && this.loc.getX() - transX <= 640.0 && (this.loc.getY() - transY >= 0.0 || this.loc.getY() + this.loc.getHeight() - transY >= 0.0) && this.loc.getY() - transY <= 640.0) {
            int i = 0;
            while (i < this.objects.size()) {
                this.objects.get(i).simpleRender(ctx, world);
                ++i;
            }
        }
        return ctx;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isAltered() {
        return this.altered;
    }

    public boolean isStructured() {
        return this.structured;
    }

    public boolean isSaveMe() {
        return this.saveMe;
    }

    @Override
    public void setLocation(Rectangle loc) {
        this.loc = loc;
    }

    @Override
    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void setObjects(ArrayList<Renderable> objects) {
        this.objects = objects;
    }

    public void setAltered(boolean altered) {
        this.altered = altered;
    }

    public void setStructured(boolean structured) {
        this.structured = structured;
    }

    public void setSaveMe(boolean saveMe) {
        this.saveMe = saveMe;
    }

    @Override
    public String getIdentifier() {
        return "GCS";
    }

    @Override
    public Renderable load(GameFile file, int line) {
        String[] args = file.getLines().get(line).split(" ");
        Chunk c = new Chunk(QuickRectangle.location(0.0, 0.0, 0.0, 0.0));
        if (args[0].trim().equalsIgnoreCase(this.getIdentifier()) && args[1].trim().equalsIgnoreCase(":")) {
            Tile t = new Tile(TileType.types.get(0), QuickRectangle.location(0.0, 0.0, 0.0, 0.0));
            c.setLocation(QuickRectangle.location(Double.parseDouble(args[2].trim()), Double.parseDouble(args[3].trim()), Double.parseDouble(args[4].trim()), Double.parseDouble(args[5].trim())));
            c.setAltered(Boolean.parseBoolean(args[6].trim()));
            c.setSortable(false);
            line = line++;
            while (line < file.getLines().size() && file.getLines().get(line) != null) {
                args = file.getLines().get(line).split(" ");
                c.getObjects().add(t.load(file, line));
                ++line;
            }
        }
        return c;
    }

    @Override
    @Deprecated
    public GameFile save(GameFile file) {
        file.getLines().add(String.valueOf(this.getIdentifier()) + " : " + this.loc.getX() + " " + this.loc.getY() + " " + this.loc.getWidth() + " " + this.loc.getHeight() + " " + this.isAltered());
        int i = 0;
        while (i < this.objects.size()) {
            if (this.objects.get(i) instanceof Tile) {
                ((Tile)this.objects.get(i)).save(file);
            }
            ++i;
        }
        return file;
    }
}

