/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2;

import com.estrelsteel.engine2.events.RenderEvent;
import com.estrelsteel.engine2.events.StartEvent;
import com.estrelsteel.engine2.events.StopEvent;
import com.estrelsteel.engine2.events.TickEvent;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.grid.PixelGrid;
import com.estrelsteel.engine2.point.AbstractedPoint;
import com.estrelsteel.engine2.shape.rectangle.AbstractedRectangle;
import com.estrelsteel.engine2.window.CoreHandler;
import com.estrelsteel.engine2.window.Stats;
import com.estrelsteel.engine2.window.WindowSettings;
import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferStrategy;
import java.text.DecimalFormat;

public class Engine2
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 1L;
    public CoreHandler coreHandler;
    public static boolean showFPS = true;
    public static boolean development = false;
    private Thread thread;
    private Stats stats = new Stats();
    private WindowSettings windowSettings = new WindowSettings(new AbstractedRectangle(new AbstractedPoint(0.0, 0.0), new AbstractedPoint(650.0, 650.0)), "Engine", "v2.0a", 0);
    public final StartEvent START_EVENT = new StartEvent();
    public final RenderEvent RENDER_EVENT = new RenderEvent();
    public final TickEvent TICK_EVENT = new TickEvent();
    public final StopEvent STOP_EVENT = new StopEvent();
    public static final DecimalFormat ROUNDING_FORMAT = new DecimalFormat("0.####");
    public static String devPath = "";
    public static final PixelGrid pixels = new PixelGrid();

    public WindowSettings getWindowSettings() {
        return this.windowSettings;
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setWindowSettings(WindowSettings windowSettings) {
        this.windowSettings = windowSettings;
    }

    public synchronized void start() {
        this.stats.setRunning(true);
        devPath = GameFile.getDataPath();
        this.coreHandler = new CoreHandler(this);
        this.addFocusListener(this.coreHandler);
        this.START_EVENT.start();
        this.thread = new Thread((Runnable)this, String.valueOf(this.windowSettings.getTitle()) + this.windowSettings.getVersion() + "_main");
        this.thread.start();
    }

    public synchronized void stop() {
        this.stats.setRunning(false);
        this.STOP_EVENT.stop();
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    @Override
    public final void run() {
        long lastTime = System.nanoTime();
        double nsPerTick = 1.6666666666666666E7;
        int ticks = 0;
        int frames = 0;
        long lastTimer = System.currentTimeMillis();
        double delta = 0.0;
        while (this.stats.isRunning()) {
            long now = System.nanoTime();
            delta += (double)(now - lastTime) / nsPerTick;
            lastTime = now;
            boolean shouldRender = true;
            while (delta >= 5.0) {
                ++ticks;
                this.tick();
                delta -= 1.0;
                shouldRender = true;
            }
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (shouldRender) {
                ++frames;
                this.render();
            }
            if (System.currentTimeMillis() - lastTimer < 1000L) continue;
            lastTimer += 1000L;
            if (showFPS) {
                System.out.println(String.valueOf(frames) + " fps, " + ticks + " tps");
            }
            this.stats.setFPS(frames);
            this.stats.setTPS(ticks);
            ticks = 0;
            frames = 0;
        }
    }

    public void tick() {
        this.stats.setTicks(this.stats.getTicks() + 1);
        this.windowSettings.getRectangle().getBottom().setX(this.getWidth());
        this.windowSettings.getRectangle().getBottom().setY(this.getWidth());
        this.TICK_EVENT.tick();
    }

    public void render() {
        this.stats.setFrames(this.stats.getFrames() + 1);
        BufferStrategy bs = this.getBufferStrategy();
        if (bs == null) {
            this.createBufferStrategy(3);
            return;
        }
        Graphics2D ctx = (Graphics2D)bs.getDrawGraphics();
        ctx.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ctx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ctx.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.RENDER_EVENT.render(ctx);
        ctx.dispose();
        bs.show();
    }
}

