/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld36.tube;

import com.estrelsteel.engine2.actor.Actor;
import com.estrelsteel.engine2.point.AbstractedPoint;
import com.estrelsteel.engine2.point.PointMaths;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.sound.SFX;
import com.estrelsteel.engine2.world.FrozenWorld;
import com.estrelsteel.ld36.LD36;
import com.estrelsteel.ld36.mail.Mail;
import com.estrelsteel.ld36.station.CapacityColours;
import com.estrelsteel.ld36.station.Station;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Tube
extends Actor {
    private Station[] stations = new Station[2];
    private long travelTime;
    private ArrayList<Mail> mail = new ArrayList();
    private int capacity = 1;

    public Tube(String name, Rectangle loc) {
        super(name, loc);
    }

    public Station[] getStations() {
        return this.stations;
    }

    public long getTravelTime() {
        return this.travelTime;
    }

    public ArrayList<Mail> getMail() {
        return this.mail;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void processMail() {
        int i = 0;
        while (i < this.mail.size()) {
            if (System.currentTimeMillis() - this.mail.get(i).getTravelTime() >= this.travelTime) {
                if (!this.stations[0].equals(this.mail.get(i).getStart())) {
                    if (this.mail.get(i).getType() == this.stations[0].getType()) {
                        LD36.score += 1.0;
                        if (LD36.sfx && !LD36.music) {
                            SFX.getSounds().get(0).play();
                        }
                    } else {
                        this.mail.get(i).setStart(this.stations[0]);
                        this.mail.get(i).setLocation(QuickRectangle.location(this.stations[0].getLocation().getX() + this.stations[0].getLocation().getWidth() + 5.0, this.stations[0].getLocation().getY() + (double)(20 * this.stations[0].getMail().size()), 16.0, 16.0));
                        this.mail.get(i).setMoved(true);
                        this.stations[0].getMail().add(this.mail.get(i));
                    }
                    this.mail.remove(i);
                    --i;
                } else {
                    if (this.mail.get(i).getType() == this.stations[1].getType()) {
                        LD36.score += 1.0;
                        if (LD36.sfx && !LD36.music) {
                            SFX.getSounds().get(0).play();
                        }
                    } else {
                        this.mail.get(i).setStart(this.stations[1]);
                        this.mail.get(i).setLocation(QuickRectangle.location(this.stations[1].getLocation().getX() + this.stations[1].getLocation().getWidth() + 5.0, this.stations[1].getLocation().getY() + (double)(20 * this.stations[1].getMail().size()), 16.0, 16.0));
                        this.mail.get(i).setMoved(true);
                        this.stations[1].getMail().add(this.mail.get(i));
                    }
                    this.mail.remove(i);
                    --i;
                }
            }
            ++i;
        }
    }

    @Override
    public Graphics2D render(Graphics2D ctx, FrozenWorld world) {
        if (this.capacity >= CapacityColours.values().length) {
            ctx.setColor(Color.BLACK);
        } else {
            ctx.setColor(CapacityColours.values()[this.capacity].getColour());
        }
        ctx.setStroke(new BasicStroke(5.0f));
        ctx.drawLine((int)(this.stations[0].getLocation().getWidth() / 2.0 + this.stations[0].getLocation().getX()), (int)(this.stations[0].getLocation().getHeight() / 2.0 + this.stations[0].getLocation().getY()), (int)(this.stations[1].getLocation().getWidth() / 2.0 + this.stations[1].getLocation().getX()), (int)(this.stations[1].getLocation().getHeight() / 2.0 + this.stations[1].getLocation().getY()));
        int i = 0;
        while (i < this.mail.size()) {
            AbstractedPoint point = PointMaths.getMidpoint(new AbstractedPoint(this.stations[0].getLocation().getWidth() / 2.0 + this.stations[0].getLocation().getX(), this.stations[0].getLocation().getHeight() / 2.0 + this.stations[0].getLocation().getY()), new AbstractedPoint(this.stations[1].getLocation().getWidth() / 2.0 + this.stations[1].getLocation().getX(), this.stations[1].getLocation().getHeight() / 2.0 + this.stations[1].getLocation().getY()));
            this.mail.get(i).setLocation(QuickRectangle.location(point.getX() + (double)(20 * i), point.getY(), 16.0, 16.0));
            this.mail.get(i).render(ctx, world);
            ++i;
        }
        return ctx;
    }

    @Override
    public Graphics2D simpleRender(Graphics2D ctx, FrozenWorld world) {
        if (this.capacity >= CapacityColours.values().length) {
            ctx.setColor(Color.BLACK);
        } else {
            ctx.setColor(CapacityColours.values()[this.capacity].getColour());
        }
        ctx.setStroke(new BasicStroke(5.0f));
        ctx.drawLine((int)(this.stations[0].getLocation().getWidth() / 2.0 + this.stations[0].getLocation().getX()), (int)(this.stations[0].getLocation().getHeight() / 2.0 + this.stations[0].getLocation().getY()), (int)(this.stations[1].getLocation().getWidth() / 2.0 + this.stations[1].getLocation().getX()), (int)(this.stations[1].getLocation().getHeight() / 2.0 + this.stations[1].getLocation().getY()));
        int i = 0;
        while (i < this.mail.size()) {
            AbstractedPoint point = PointMaths.getMidpoint(new AbstractedPoint(this.stations[0].getLocation().getWidth() / 2.0 + this.stations[0].getLocation().getX(), this.stations[0].getLocation().getHeight() / 2.0 + this.stations[0].getLocation().getY()), new AbstractedPoint(this.stations[1].getLocation().getWidth() / 2.0 + this.stations[1].getLocation().getX(), this.stations[1].getLocation().getHeight() / 2.0 + this.stations[1].getLocation().getY()));
            this.mail.get(i).setLocation(QuickRectangle.location(point.getX() + (double)(20 * i), point.getY(), 16.0, 16.0));
            this.mail.get(i).simpleRender(ctx, world);
            ++i;
        }
        return ctx;
    }

    public void setStations(Station[] stations) {
        this.stations = stations;
    }

    public void setTravelTime(long travelTime) {
        this.travelTime = travelTime;
    }

    public void setMail(ArrayList<Mail> mail) {
        this.mail = mail;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

