/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld36.station;

import com.estrelsteel.engine2.image.Renderable;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.shape.rectangle.Rectangle;
import com.estrelsteel.engine2.world.FrozenWorld;
import com.estrelsteel.ld36.mail.Mail;
import com.estrelsteel.ld36.mail.MailType;
import com.estrelsteel.ld36.mail.PendingMail;
import com.estrelsteel.ld36.station.Station;
import com.estrelsteel.ld36.tube.PendingTube;
import com.estrelsteel.ld36.tube.Tube;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class Level
implements Renderable {
    private String name;
    private ArrayList<Station> stations;
    private int active;
    private ArrayList<Tube> tubes;
    private ArrayList<PendingMail> pMail;
    private ArrayList<PendingTube> pTube;

    public Level(String name) {
        this.name = name;
        this.stations = new ArrayList();
        this.active = 1;
        this.tubes = new ArrayList();
        this.pMail = new ArrayList();
        this.pTube = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Station> getStations() {
        return this.stations;
    }

    public int getActiveStation() {
        return this.active;
    }

    public ArrayList<Tube> getTubes() {
        return this.tubes;
    }

    public ArrayList<PendingMail> getPendingMail() {
        return this.pMail;
    }

    public ArrayList<PendingTube> getPendingTube() {
        return this.pTube;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStations(ArrayList<Station> stations) {
        this.stations = stations;
    }

    public void setActiveStation(int active) {
        this.active = active;
    }

    public void setTubes(ArrayList<Tube> tubes) {
        this.tubes = tubes;
    }

    public void setPendingMail(ArrayList<PendingMail> pMail) {
        this.pMail = pMail;
    }

    public void setPendingTube(ArrayList<PendingTube> pTube) {
        this.pTube = pTube;
    }

    private Tube checkRoute(ArrayList<Station> start, MailType target, Tube tube, int path) {
        int j = 0;
        while (j < start.size()) {
            if (!tube.getStations()[path].equals(start.get(j))) {
                if (tube.getStations()[path].getType() == target) {
                    return tube;
                }
                start.add(tube.getStations()[path]);
                if (this.traverseTubes2(start, target) != null) {
                    return tube;
                }
            }
            ++j;
        }
        return null;
    }

    private Tube traverseTubes2(ArrayList<Station> start, MailType target) {
        Tube tube = null;
        int i = 0;
        while (i < this.tubes.size()) {
            tube = this.tubes.get(i);
            if (tube.getCapacity() > tube.getMail().size() && (tube.getStations()[0].equals(start.get(start.size() - 1)) && !start.contains(tube.getStations()[1]) ? (tube = this.checkRoute(start, target, tube, 1)) != null : tube.getStations()[1].equals(start.get(start.size() - 1)) && !start.contains(tube.getStations()[0]) && (tube = this.checkRoute(start, target, tube, 0)) != null)) {
                return tube;
            }
            ++i;
        }
        return null;
    }

    public int calcTotalTubes() {
        int tot = 0;
        int i = 0;
        while (i < this.tubes.size()) {
            tot += this.tubes.get(i).getCapacity();
            ++i;
        }
        return tot;
    }

    public int checkAvaliableMail() {
        int tot = 0;
        int i = 0;
        while (i < this.tubes.size()) {
            tot += this.tubes.get(i).getMail().size();
            ++i;
        }
        i = 0;
        while (i < this.stations.size()) {
            tot += this.stations.get(i).getMail().size();
            ++i;
        }
        return tot += this.pMail.size();
    }

    public boolean checkForExpiredMail() {
        int j;
        int i = 0;
        while (i < this.tubes.size()) {
            j = 0;
            while (j < this.tubes.get(i).getMail().size()) {
                if (System.currentTimeMillis() - this.tubes.get(i).getMail().get(j).getStartTime() >= 22000L) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.stations.size()) {
            j = 0;
            while (j < this.stations.get(i).getMail().size()) {
                if (System.currentTimeMillis() - this.stations.get(i).getMail().get(j).getStartTime() >= 22000L) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private Tube findDirectRoute(Station start, MailType target) {
        Tube tube = null;
        int i = 0;
        while (i < this.tubes.size()) {
            tube = this.tubes.get(i);
            if (tube.getCapacity() > tube.getMail().size() && (tube.getStations()[0].equals(start) ? tube.getStations()[1].getType() == target : tube.getStations()[1].equals(start) && tube.getStations()[0].getType() == target)) {
                return tube;
            }
            ++i;
        }
        ArrayList<Station> s1 = new ArrayList<Station>();
        s1.add(start);
        return this.traverseTubes2(s1, target);
    }

    public Tube findTubeWithDestination(Station start, MailType target) {
        return this.findDirectRoute(start, target);
    }

    public void spawnMail(Station s) {
        int rType = (int)(Math.random() * (double)MailType.values().length - 1.0);
        if (s == null) {
            int rStation = (int)(Math.random() * (double)(this.active + 1));
            s = this.stations.get(rStation);
        }
        if (MailType.values()[rType + 1] != s.getType()) {
            Mail mail = new Mail(QuickRectangle.location(s.getLocation().getX() + s.getLocation().getWidth() + 5.0, s.getLocation().getY() + (double)(20 * s.getMail().size()), 16.0, 16.0), MailType.values()[rType + 1]);
            mail.setStart(s);
            mail.setStartTime(System.currentTimeMillis());
            s.getMail().add(mail);
        } else {
            this.spawnMail(s);
        }
    }

    @Override
    public Rectangle getLocation() {
        return QuickRectangle.location(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public Graphics2D render(Graphics2D ctx, FrozenWorld world) {
        int i = 0;
        while (i < this.tubes.size()) {
            ctx = this.tubes.get(i).render(ctx, world);
            ++i;
        }
        i = 0;
        while (i <= this.active && i < this.stations.size()) {
            ctx = this.stations.get(i).render(ctx, world);
            int j = 0;
            while (j < this.stations.get(i).getMail().size()) {
                ctx = this.stations.get(i).getMail().get(j).render(ctx, world);
                ++j;
            }
            ++i;
        }
        return ctx;
    }

    @Override
    public Graphics2D simpleRender(Graphics2D ctx, FrozenWorld world) {
        int i = 0;
        while (i < this.tubes.size()) {
            ctx = this.tubes.get(i).simpleRender(ctx, world);
            ++i;
        }
        i = 0;
        while (i <= this.active && i < this.stations.size()) {
            ctx = this.stations.get(i).simpleRender(ctx, world);
            int j = 0;
            while (j < this.stations.get(i).getMail().size()) {
                ctx = this.stations.get(i).getMail().get(j).simpleRender(ctx, world);
                ++j;
            }
            ++i;
        }
        return ctx;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public void setLocation(Rectangle loc) {
    }

    @Override
    public void setSortable(boolean sortable) {
    }
}

