/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.ld36;

import com.estrelsteel.engine2.Engine2;
import com.estrelsteel.engine2.Launcher;
import com.estrelsteel.engine2.events.listener.RenderListener;
import com.estrelsteel.engine2.events.listener.StartListener;
import com.estrelsteel.engine2.events.listener.StopListener;
import com.estrelsteel.engine2.events.listener.TickListener;
import com.estrelsteel.engine2.file.GameFile;
import com.estrelsteel.engine2.grid.PixelGrid;
import com.estrelsteel.engine2.image.Image;
import com.estrelsteel.engine2.shape.rectangle.QuickRectangle;
import com.estrelsteel.engine2.sound.SFX;
import com.estrelsteel.engine2.window.WindowSettings;
import com.estrelsteel.engine2.world.World;
import com.estrelsteel.ld36.InputHandler;
import com.estrelsteel.ld36.Note;
import com.estrelsteel.ld36.mail.Mail;
import com.estrelsteel.ld36.mail.MailType;
import com.estrelsteel.ld36.mail.PendingMail;
import com.estrelsteel.ld36.station.Level;
import com.estrelsteel.ld36.station.Station;
import com.estrelsteel.ld36.tube.PendingTube;
import com.estrelsteel.ld36.tube.Tube;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class LD36
implements StartListener,
TickListener,
RenderListener,
StopListener {
    private Launcher l = new Launcher();
    private World world;
    public static double score;
    public int tubes;
    private InputHandler input;
    public int lvl = 0;
    private Mail tempM;
    private Tube tempT;
    public int start;
    private Image map;
    private double tubeAdd;
    private Random rand;
    public static boolean music;
    public static boolean sfx;
    public static SFX effect;
    public boolean paused;
    private ArrayList<Image> maps;

    public static void main(String[] args) {
        new LD36();
    }

    public LD36() {
        this.l.getEngine().setWindowSettings(new WindowSettings(QuickRectangle.location(0.0, 0.0, 640.0, 640.0), "Pneumatic Pipe Manager", "v1.0b", 1));
        this.l.getEngine().START_EVENT.addListener(this);
        this.l.getEngine().STOP_EVENT.addListener(this);
        this.l.getEngine().RENDER_EVENT.addListener(this);
        this.l.getEngine().TICK_EVENT.addListener(this);
        this.input = new InputHandler(this);
        this.l.getEngine().addKeyListener(this.input);
        this.l.getEngine().addMouseListener(this.input);
        this.l.getEngine().addMouseMotionListener(this.input);
        this.l.getEngine();
        Engine2.development = true;
        this.l.getEngine();
        Engine2.devPath = GameFile.getCurrentPath();
        MailType.updateSRC();
        this.rand = new Random();
        music = true;
        sfx = true;
        this.paused = false;
        GameFile sound = new GameFile(String.valueOf(Engine2.devPath) + "/res/sounds.txt");
        try {
            sound.updateLines();
            effect = new SFX();
            effect.load(sound, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.l.boot();
    }

    public World getWorld() {
        return this.world;
    }

    public Launcher getLauncher() {
        return this.l;
    }

    @Override
    public void start() {
        score = 0.0;
        this.tubes = 0;
        this.start = Integer.MIN_VALUE;
        this.world = new World(new PixelGrid());
        this.l.getEngine();
        GameFile levels = new GameFile(String.valueOf(Engine2.devPath) + "/lvl/lvls.txt");
        try {
            levels.updateLines();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Station station = new Station(MailType.UNKNOWN, QuickRectangle.location(0.0, 0.0, 0.0, 0.0));
        PendingMail pMail = new PendingMail(0);
        PendingTube pTube = new PendingTube(0);
        this.maps = new ArrayList();
        for (String line : levels.getLines()) {
            String[] args = line.split(" ");
            Level lvl = new Level(args[0]);
            this.maps.add(new Image(String.valueOf(Engine2.devPath) + args[2].trim()));
            this.l.getEngine();
            GameFile lvlFile = new GameFile(String.valueOf(Engine2.devPath) + "/lvl" + args[1]);
            try {
                lvlFile.updateLines();
                int i = 0;
                while (i < lvlFile.getLines().size()) {
                    if ((station = station.load(lvlFile, i)) != null) {
                        lvl.getStations().add(station.load(lvlFile, i));
                    } else {
                        station = new Station(MailType.UNKNOWN, QuickRectangle.location(0.0, 0.0, 0.0, 0.0));
                        if ((pMail = pMail.load(lvlFile, i)) != null) {
                            lvl.getPendingMail().add(pMail);
                        } else {
                            pMail = new PendingMail(0);
                            if ((pTube = pTube.load(lvlFile, i)) != null) {
                                lvl.getPendingTube().add(pTube);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.world.getObjects().add(lvl);
        }
        this.map = this.maps.get(0);
        Note note = new Note(QuickRectangle.location(0.0, 0.0, 0.0, 0.0));
        this.l.getEngine();
        GameFile notes = new GameFile(String.valueOf(Engine2.devPath) + "/notes/notes.txt");
        try {
            notes.updateLines();
            int i = 0;
            while (i < notes.getLines().size()) {
                this.l.getEngine();
                GameFile n = new GameFile(String.valueOf(Engine2.devPath) + "/notes" + notes.getLines().get(i));
                n.updateLines();
                note = note.load(n, 0);
                this.world.getObjects().add(note);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.world.getObjects().get(1) instanceof Note) {
            ((Note)this.world.getObjects().get(1)).setVisible(true);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public Graphics2D render(Graphics2D ctx) {
        if (!this.map.isImageLoaded()) {
            this.map.loadImage();
        }
        ctx.drawImage(this.map.getImage(), 0, 0, 640, 640, null);
        if (this.input.drawingTube) {
            ctx.setStroke(new BasicStroke(5.0f));
            ctx.setColor(Color.GREEN);
            ctx.drawLine((int)(this.input.start.getLocation().getWidth() / 2.0 + this.input.start.getLocation().getX()), (int)(this.input.start.getLocation().getHeight() / 2.0 + this.input.start.getLocation().getY()), this.input.mouseX, this.input.mouseY);
        } else if (this.input.drawingDel) {
            ctx.setStroke(new BasicStroke(5.0f));
            ctx.setColor(Color.RED);
            ctx.drawLine((int)(this.input.start.getLocation().getWidth() / 2.0 + this.input.start.getLocation().getX()), (int)(this.input.start.getLocation().getHeight() / 2.0 + this.input.start.getLocation().getY()), this.input.mouseX, this.input.mouseY);
        }
        this.world.simpleRenderWorld(ctx);
        ctx.setFont(new Font("Menlo", 1, 16));
        ctx.setColor(Color.BLACK);
        if (this.world.getObjects().size() > 0 && this.world.getObjects().get(1) instanceof Note && this.world.getObjects().get(2) instanceof Note && this.world.getObjects().get(3) instanceof Note && !((Note)this.world.getObjects().get(1)).isVisible() && !((Note)this.world.getObjects().get(2)).isVisible() && !((Note)this.world.getObjects().get(3)).isVisible()) {
            ctx.drawString("Avaliable Pipes: " + (this.tubes - ((Level)this.world.getObjects().get(this.lvl)).calcTotalTubes()), 20, 600);
            ctx.drawString("Deliveries: " + (int)score, 475, 600);
        }
        return ctx;
    }

    @Override
    public void tick() {
        int y;
        int j;
        if (this.world.getObjects().size() <= 0) {
            return;
        }
        if (music && !((Note)this.world.getObjects().get(2)).isVisible()) {
            SFX.getSounds().get(1).play();
        } else if (SFX.getSounds().get(1).getClip().isRunning()) {
            SFX.getSounds().get(1).getClip().setFramePosition(0);
            SFX.getSounds().get(1).getClip().stop();
            SFX.getSounds().get(1).getClip().flush();
        }
        if (this.paused) {
            return;
        }
        int i = 0;
        while (i < ((Level)this.world.getObjects().get(this.lvl)).getTubes().size()) {
            j = 0;
            while (j < ((Level)this.world.getObjects().get(this.lvl)).getTubes().get(i).getMail().size()) {
                ((Level)this.world.getObjects().get(this.lvl)).getTubes().get(i).getMail().get(j).getAnimations().get(0).run();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ((Level)this.world.getObjects().get(this.lvl)).getStations().size()) {
            j = 0;
            while (j < ((Level)this.world.getObjects().get(this.lvl)).getStations().get(i).getMail().size()) {
                ((Level)this.world.getObjects().get(this.lvl)).getStations().get(i).getMail().get(j).getAnimations().get(0).run();
                ++j;
            }
            ++i;
        }
        if (this.l.getEngine().getStats().getTicks() % 60 == 0) {
            i = 0;
            while (i < ((Level)this.world.getObjects().get(this.lvl)).getTubes().size()) {
                ((Level)this.world.getObjects().get(this.lvl)).getTubes().get(i).processMail();
                ++i;
            }
            i = 0;
            while (i < ((Level)this.world.getObjects().get(this.lvl)).getStations().size()) {
                j = 0;
                while (j < ((Level)this.world.getObjects().get(this.lvl)).getStations().get(i).getMail().size()) {
                    this.tempM = ((Level)this.world.getObjects().get(this.lvl)).getStations().get(i).getMail().get(j);
                    if (!this.tempM.hasMoved()) {
                        this.tempT = ((Level)this.world.getObjects().get(this.lvl)).findTubeWithDestination(this.tempM.getStart(), this.tempM.getType());
                        if (this.tempT != null) {
                            this.tempM.setTravelTime(System.currentTimeMillis());
                            this.tempT.getMail().add(this.tempM);
                            ((Level)this.world.getObjects().get(this.lvl)).getStations().get(i).getMail().remove(j);
                            --j;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < ((Level)this.world.getObjects().get(this.lvl)).getTubes().size()) {
                j = 0;
                while (j < ((Level)this.world.getObjects().get(this.lvl)).getTubes().get(i).getMail().size()) {
                    ((Level)this.world.getObjects().get(this.lvl)).getTubes().get(i).getMail().get(j).setMoved(false);
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < ((Level)this.world.getObjects().get(this.lvl)).getStations().size()) {
                j = 0;
                while (j < ((Level)this.world.getObjects().get(this.lvl)).getStations().get(i).getMail().size()) {
                    ((Level)this.world.getObjects().get(this.lvl)).getStations().get(i).getMail().get(j).setMoved(false);
                    ++j;
                }
                ++i;
            }
        }
        if (((Level)this.world.getObjects().get(this.lvl)).getPendingMail().size() > 0) {
            if (((Level)this.world.getObjects().get(this.lvl)).getPendingMail().get(0).getSpawn() <= this.l.getEngine().getStats().getTicks() - this.start) {
                ((Level)this.world.getObjects().get(this.lvl)).spawnMail(null);
                ((Level)this.world.getObjects().get(this.lvl)).getPendingMail().remove(0);
            }
        } else if (((Level)this.world.getObjects().get(this.lvl)).getPendingMail().size() <= 0 && (this.l.getEngine().getStats().getTicks() - this.start) % 480 == 0) {
            y = (int)(0.99 * Math.pow(1.015, (this.l.getEngine().getStats().getTicks() - this.start) / 240)) + 15;
            Station s = null;
            if (this.rand.nextDouble() < 0.15) {
                s = ((Level)this.world.getObjects().get(this.lvl)).getStations().get((int)(this.rand.nextDouble() * (double)((Level)this.world.getObjects().get(this.lvl)).getActiveStation()));
            }
            while (y > 0) {
                ((Level)this.world.getObjects().get(this.lvl)).spawnMail(s);
                --y;
            }
        }
        if (((Level)this.world.getObjects().get(this.lvl)).getActiveStation() + 1 < ((Level)this.world.getObjects().get(this.lvl)).getStations().size() && (double)((Level)this.world.getObjects().get(this.lvl)).getStations().get(((Level)this.world.getObjects().get(this.lvl)).getActiveStation() + 1).getRequiredMail() <= score) {
            ((Level)this.world.getObjects().get(this.lvl)).setActiveStation(((Level)this.world.getObjects().get(this.lvl)).getActiveStation() + 1);
        }
        if (((Level)this.world.getObjects().get(this.lvl)).getPendingTube().size() > 0) {
            if (score >= (double)((Level)this.world.getObjects().get(this.lvl)).getPendingTube().get(0).getSpawn()) {
                ((Level)this.world.getObjects().get(this.lvl)).getPendingTube().remove(0);
                ++this.tubes;
            }
        } else if (((Level)this.world.getObjects().get(this.lvl)).getPendingTube().size() <= 0 && score - this.tubeAdd > 50.0) {
            ++this.tubes;
            this.tubeAdd = score;
        }
        if (((Level)this.world.getObjects().get(this.lvl)).checkAvaliableMail() - ((Level)this.world.getObjects().get(this.lvl)).getPendingMail().size() <= 0) {
            y = (int)(0.99 * Math.pow(1.015, (this.l.getEngine().getStats().getTicks() - this.start) / 240));
            Station s = null;
            if (this.rand.nextDouble() < 0.15) {
                s = ((Level)this.world.getObjects().get(this.lvl)).getStations().get((int)(this.rand.nextDouble() * (double)((Level)this.world.getObjects().get(this.lvl)).getActiveStation()));
            }
            while (y > 0) {
                ((Level)this.world.getObjects().get(this.lvl)).spawnMail(s);
                --y;
            }
        }
        if (((Level)this.world.getObjects().get(this.lvl)).checkForExpiredMail() && this.world.getObjects().get(2) instanceof Note && !((Note)this.world.getObjects().get(2)).isVisible()) {
            ((Note)this.world.getObjects().get(2)).setVisible(true);
            ((Note)this.world.getObjects().get(2)).getText().get(1).setText(String.valueOf(((Note)this.world.getObjects().get(2)).getText().get(1).getText()) + (int)score);
            if (music) {
                SFX.getSounds().get(1).getClip().stop();
                SFX.getSounds().get(4).play();
            }
        }
    }
}

