/*
 * Decompiled with CFR 0.152.
 */
package com.estrelsteel.engine2.world;

import com.estrelsteel.engine2.grid.Grid;
import com.estrelsteel.engine2.image.Renderable;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class FrozenWorld {
    private ArrayList<Renderable> objects;
    private Grid grid;
    private ArrayList<Renderable> helper;

    public FrozenWorld(Grid grid) {
        this.grid = grid;
        this.objects = new ArrayList();
    }

    public Grid getGrid() {
        return this.grid;
    }

    public ArrayList<Renderable> getObjects() {
        return this.objects;
    }

    public boolean equals(Object other) {
        return this.grid.equals(((FrozenWorld)other).getGrid()) && this.objects.equals(((FrozenWorld)other).getObjects());
    }

    public Graphics2D renderWorld(Graphics2D ctx) {
        int i = 0;
        while (i < this.objects.size()) {
            ctx = this.objects.get(i).render(ctx, this);
            ++i;
        }
        return ctx;
    }

    public Graphics2D simpleRenderWorld(Graphics2D ctx) {
        int i = 0;
        while (i < this.objects.size()) {
            ctx = this.objects.get(i).simpleRender(ctx, this);
            ++i;
        }
        return ctx;
    }

    public void sortObjects() {
        if (!this.checkSort()) {
            ArrayList<Renderable> keep = new ArrayList<Renderable>();
            this.helper = new ArrayList();
            int i = 0;
            while (i < this.objects.size()) {
                this.helper.add(this.objects.get(i));
                if (!this.objects.get(i).isSortable()) {
                    keep.add(this.objects.get(i));
                    this.objects.remove(i);
                    --i;
                }
                ++i;
            }
            this.mergeSort(0, this.objects.size() - 1);
            i = 0;
            while (i < keep.size()) {
                if (keep.get(i) != null) {
                    this.objects.add(0, (Renderable)keep.get(i));
                }
                ++i;
            }
        }
    }

    public boolean checkSort() {
        int l = 0;
        int i = 1;
        while (i < this.objects.size()) {
            if (!(this.objects.get(i).getLocation().getY() + this.objects.get(i).getLocation().getHeight() <= this.objects.get(l).getLocation().getY() + this.objects.get(l).getLocation().getHeight()) && this.objects.get(i).isSortable() && this.objects.get(l).isSortable()) {
                return false;
            }
            if (this.objects.get(i).isSortable()) {
                l = i;
            }
            ++i;
        }
        return true;
    }

    private void mergeSort(int low, int high) {
        if (low < high) {
            int middle = low + (high - low) / 2;
            this.mergeSort(low, middle);
            this.mergeSort(middle + 1, high);
            this.merge(low, middle, high);
        }
    }

    private void merge(int low, int middle, int high) {
        int i = low;
        while (i <= high) {
            this.helper.set(i, this.objects.get(i));
            ++i;
        }
        i = low;
        int j = middle + 1;
        int k = low;
        while (i <= middle && j <= high) {
            if (this.helper.get(i).getLocation().getY() + this.helper.get(i).getLocation().getHeight() <= this.helper.get(j).getLocation().getY() + this.helper.get(j).getLocation().getHeight()) {
                this.objects.set(k, this.helper.get(i));
                ++i;
            } else {
                this.objects.set(k, this.helper.get(j));
                ++j;
            }
            ++k;
        }
        while (i <= middle) {
            this.objects.set(k, this.helper.get(i));
            ++k;
            ++i;
        }
    }

    public void setObjects(ArrayList<Renderable> objects) {
        this.objects = objects;
    }
}

